<?php $__env->startSection('content'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/survey.css')); ?>">

<div class="container">
    <div class="form-container sections">
    <form class="row g-3" id="household-visit-form">
        <?php echo csrf_field(); ?>
	<!-- Campo oculto para enviar el form_id -->
    	<input type="hidden" name="form_id" value="<?php echo e($form_id); ?>">
        <div class="row sub survey-section">
            <h3 class="subtitle">DATOS DEL HOGAR A VISITAR</h3>
        </div>

        <!-- Correlativo del Segmento Cartográfico -->
	<div class="row">
        <div class="col-md-6">
            <label for="p1" class="form-label">Correlativo del Segmento Cartográfico</label>
            <select id="p1" name="p1" class="form-select select2" required>
                <option value="">Seleccione un segmento...</option>
                <?php $__currentLoopData = $segmentUser; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $segment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($segment->correlativo_segmento); ?>"><?php echo e($segment->correlativo_segmento); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <!-- Región de Salud -->
        <div class="col-md-6">
            <label for="p2" class="form-label">Región de Salud</label>
            <input type="text" id="p2" class="form-control" name="p2" readonly>
        </div>
	</div>
	<div class="row">

        <!-- Departamento -->
        <div class="col-md-6">
            <label for="p3" class="form-label">Departamento</label>
            <input type="text" id="p3" class="form-control" name="p3" readonly>
        </div>

        <!-- Municipio -->
        <div class="col-md-6">
            <label for="p4" class="form-label">Municipio</label>
            <input type="text" id="p4" class="form-control" name="p4" readonly>
        </div>
	</div>
        <div class="row">
        <!-- Distrito -->
        <div class="col-md-6">
            <label for="p5" class="form-label">Distrito</label>
            <input type="text" id="p5" class="form-control" name="p5" readonly>
        </div>

        <!-- Área -->
        <div class="col-md-6">
            <label for="p6" class="form-label">Área</label>
            <input type="text" id="p6" class="form-control" name="p6" readonly>
        </div>
	</div>
        <div class="row">
	<!-- Nombre de Supervisor de Gestión Local -->
	<div class="col-md-12">
	    <label for="p7" class="form-label">Nombre de Supervisor de Gestión Local</label>
	    <input type="text" id="p7" class="form-control" name="p7" value="<?php echo e($user->name); ?>" readonly>
	</div>
	</div>
        <div class="row">
	<!-- Fecha de Visita y Levantamiento de Datos -->
	<div class="col-md-12">
	    <label for="p8" class="form-label">Fecha de visita y levantamiento de datos</label>
	    <input type="text" id="p8" class="form-control" name="p8" value="<?php echo e($currentDate); ?>" readonly>
	</div>
	</div>
        <div class="row">
	<!-- Hora de Inicio -->
	<div class="col-md-6">
	    <label for="p9" class="form-label">Hora de Inicio</label>
	    <input type="text" id="p9" class="form-control" name="p9" value="<?php echo e($currentTime); ?>" readonly>
	</div>
	<!-- Hora de Finalización -->
        <div class="col-md-6">
            <label for="p10" class="form-label">Hora de Finalización</label>
            <input type="text" id="p10" class="form-control" name="p10" readonly>
        </div>
	</div>
	<!-- Sección de Coordinación Local -->
	 <div class="row sub survey-section">
            <h3 class="subtitle">COORDINACION LOCAL</h3>
        </div>
	
        <!-- Tabla de Registros Agregados con DataTables -->
	<div class="col-12 mb-3">
	    <table id="coordinationTable" class="table table-striped table-bordered" style="width:100%">
	        <thead>
	            <tr>
	                <th>Institución</th>
	                <th>Nombre de Establecimiento</th>
	                <th>Nombre de Jefatura</th>
	                <th>Teléfono Fijo</th>
	                <th>Teléfono Móvil</th>
	                <th>Correo Electrónico</th>
	                <th>Acciones</th>
	            </tr>
	        </thead>
	        <tbody id="coordination-rows">
	            <!-- Las filas se agregarán aquí dinámicamente -->
	        </tbody>
	    </table>
	</div>
	<!-- Botón para agregar más coordinaciones -->
	<div class="col-12 mb-3">
	   <button type="button" id="add-coordination-btn" class="btn btn-success" disabled>Agregar Coordinación</button>
	</div>
        <!-- Botón de enviar -->
	<table id="supportStaffTable" class="table table-bordered table-hover">
	    <thead>
	        <tr>
	            <th>Número</th>
	            <th>Nombre completo</th>
	            <th>Institución</th>
	            <th>Cargo</th>
		    <th>Especifíque</th>
	            <th>Teléfono fijo</th>
	            <th>Teléfono móvil</th>
	            <th>Correo electrónico</th>
	            <th>Acciones</th>
	        </tr>
	    </thead>
	    <tbody>
	        <!-- Las filas se generarán dinámicamente -->
	    </tbody>
	</table>
	<div class="col-12 mb-3">
	<button type="button" id="add-support-btn" class="btn btn-success" disabled>Agregar Personal</button>
	</div>

	<!-- Continuacion -->
	<div class="row" >
	    <div class="col-md-4">
	    <div class="form-group">
	    	<label for="p24" title="En la unidad de salud hay laboratorio clínico">En la unidad de salud hay laboratorio clínico:</label>
	    	<select id="p24" name="p24" class="form-control" required>
	    	     <option value="">Seleccione...</option>
	   	     <option value="1">Sí</option>
	   	     <option value="2">No</option>
	    	</select>
	    </div>
	    </div>
        
	    <div id="labInfo" class="col-md-8 row hidden">
	    <div class="col-md-5">
            <div class="form-group">
	   	<label for="p25" title="Nombre de jefe(a) de laboratorio">Nombre de jefe(a) de laboratorio:</label>
	   	<input type="text" id="p25" name="p25" class="form-control" required>
	    </div>
            </div>

            <div class="col-md-3">
	    <div class="form-group">
	    	<label for="p26" title="Teléfono móvil">Teléfono móvil:</label>
		<input type="tel" id="p26" name="p26" class="form-control" required>
	    </div>
            </div>

            <div class="col-md-4">
            <div class="form-group">
		<label for="p27">Correo electrónico:</label>
	    	<input type="email" id="p27" name="p27" class="form-control">
	    </div>
	    </div>
	    </div>
	</div>
	<div class="row">
	    <div class="col-md-4">
	    <div class="form-group">
	    	<label for="p28" title="En el área a trabajar hay promotor(a) de Salud responsable del área">En el área a trabajar hay promotor(a) de Salud responsable del área:</label>
	    	<select id="p28" name="p28" class="form-control" required>
	   	     <option value="">Seleccione...</option>
	   	     <option value="1">Sí</option>
	   	     <option value="2">No</option>
	    	</select>
      	    </div>
	    </div>

	    <div id="labInfo2" class="col-md-8 row hidden">
  	    <div class="col-md-5">
	    <div class="form-group">
	    	<label for="p29" title="Nombre de promotor(a) de salud">Nombre de promotor(a) de salud:</label>
	    	<input type="text" id="p29" name="p29" class="form-control" required>
	    </div>
	    </div>

	    <div class="col-md-3">
	    <div class="form-group">
	    	<label for="p30" title="Teléfono móvil">Teléfono móvil:</label>
	    	<input type="tel" id="p30" name="p30" class="form-control" required>
	    </div>
	    </div>

	    <div class="col-md-4">
  	    <div class="form-group">
	    	<label for="p31">Correo electrónico:</label>
	    	<input type="email" id="p31" name="p31" class="form-control">
	    </div>
	    </div>
	    </div>
	</div>
	<div class="form-group">
	    <label for="p32">Resultado final de la coordinación:</label>
	    <select id="p32" name="p32" class="form-control" required>
	        <option value="">Seleccione...</option>
	        <option value="1">Completa</option>
	        <option value="2">Incompleta</option>
	        <option value="3">Ausente</option>
	        <option value="4">Rechazo</option>
        	<option value="5">Sin acceso a la información</option>
	    </select>
	</div>

	<div class="form-group">
	    <label for="observaciones">Observaciones:</label>
	    <textarea id="observaciones" name="observaciones" class="form-control" rows="4"></textarea>
	</div>

        <div class="col-12">
            <button type="submit" class="btn btn-primary">Guardar</button>
        </div>

    </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {

    // Inicializar DataTable con opciones de diseño compacto y scroll
    var table = $('#coordinationTable').DataTable({
	"language": {
                url: '/js/i18n/es-MX.json'
        },
        "paging": true,
        "lengthChange": false,
        "searching": false,
        "ordering": true,
        "info": true,
        "autoWidth": true, // Permitir el ajuste automático de las columnas
    	"scrollCollapse": true,
    	"scrollX": true, // Habilitar scroll horizontal si es necesario
        "columnDefs": [
            { "width": "20%", "targets": 0 },
            { "width": "20%", "targets": 1 },
            { "width": "20%", "targets": 2 },
            { "width": "10%", "targets": 3 },
            { "width": "10%", "targets": 4 },
            { "width": "10%", "targets": 5 },
            { "width": "10%", "targets": 6 }
        ]
    });
    var supportTable = $('#supportStaffTable').DataTable({
        "language": {
                url: '/js/i18n/es-MX.json'
        },
	"paging": true,
	"lengthChange": false,
        "searching": false,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "scrollX": true,
        "columnDefs": [
            { "width": "5%", "targets": 0 },
            { "width": "20%", "targets": 1 },
            { "width": "10%", "targets": 2 },
            { "width": "10%", "targets": 3 },
            { "width": "10%", "targets": 4, "visible": false},
            { "width": "10%", "targets": 5 },
            { "width": "15%", "targets": 6 },
	    { "width": "15%", "targets": 7 },
	    { "width": "10%", "targets": 8 }

        ]
    });
    $('#p1').change(function() {
        var segmentId = $(this).val();
        if (segmentId) {
            $.ajax({
               url: '/household-visit/segment-detail/' + segmentId,
               type: 'GET',
               success: function(data) {
                    if (data) {
                        $('#p2').val(data.region);
                        $('#p3').val(data.department);
                        $('#p4').val(data.muni);
                        $('#p5').val(data.distrito);
                        $('#p6').val(data.area);
                    }
                }
            });
        } else {
            // Limpiar los inputs si no hay un segmento seleccionado
            $('#p2').val('');
            $('#p3').val('');
            $('#p4').val('');
            $('#p5').val('');
            $('#p6').val('');
        }
    });
    $('#p1').change(function() {
        var segmentValue = $(this).val(); // Obtiene el valor seleccionado
        var addCoordinationBtn = $('#add-coordination-btn');
        var addSupportBtn  = $('#add-support-btn');
        // Si se selecciona un segmento, habilita el botón; de lo contrario, deshabilítalo
        if (segmentValue) {
            addCoordinationBtn.prop('disabled', false); // Habilita el botón
            addSupportBtn.prop('disabled', false); // Habilita el botón
        } else {
            addCoordinationBtn.prop('disabled', true); // Deshabilita el botón
            addSupportBtn.prop('disabled', true); // Habilita el botón
        }
    });

    // Detecta el cambio en el select de p24
    $('#p24').change(function() {
        var selectedValue = $(this).val();

        if (selectedValue === '1') {
            // Si la opción es "Sí", muestra los campos
            $('#labInfo').removeClass('hidden');
        } else {
            // Si la opción es "No" u otra cosa, oculta los campos
            $('#labInfo').addClass('hidden');
        }
    });
     // Detecta el cambio en el select de p24
    $('#p28').change(function() {
        var selectedValue = $(this).val();

        if (selectedValue === '1') {
            // Si la opción es "Sí", muestra los campos
            $('#labInfo2').removeClass('hidden');
        } else {
            // Si la opción es "No" u otra cosa, oculta los campos
            $('#labInfo2').addClass('hidden');
        }
    });
    // Manejar el envío del formulario
    $('#household-visit-form').on('submit', function(e) {
        e.preventDefault(); // Evita el envío normal del formulario
	
        // Empaquetar las respuestas del encabezado
        var headerData = {
            p1: $('#p1').val(),
            p2: $('#p2').val(),
            p3: $('#p3').val(),
            p4: $('#p4').val(),
            p5: $('#p5').val(),
            p6: $('#p6').val(),
            p7: $('#p7').val(),
            p8: $('#p8').val(),
            p9: $('#p9').val(),
            p10: $('#p10').val()
        };

        // Empaquetar las respuestas del DataTable (coordinaciones locales)
        var tableData = [];
        $('#coordinationTable tbody tr').each(function() {
            var row = {
                p11: $(this).find('select[name="p11[]"]').val(),
                p12: $(this).find('select[name="p12[]"]').val(),
                p13: $(this).find('input[name="p13[]"]').val(),
                p14: $(this).find('input[name="p14[]"]').val(),
                p15: $(this).find('input[name="p15[]"]').val(),
                p16: $(this).find('input[name="p16[]"]').val()
            };
            tableData.push(row);
        });
        var supportTableData = [];
        $('#supportStaffTable tbody tr').each(function() {
            var row = {
                p17: $(this).find('input[name="p17[]"]').val(),
                p18: $(this).find('input[name="p18[]"]').val(),
                p19: $(this).find('input[name="p19[]"]').val(),
                p20: $(this).find('input[name="p20[]"]').val(),
                p20_: $(this).find('input[name="p20_[]"]').val(),
                p21: $(this).find('input[name="p21[]"]').val(),
                p22: $(this).find('input[name="p22[]"]').val(),
                p23: $(this).find('input[name="p23[]"]').val()
            };
            supportTableData.push(row);
        });
        var supportTableData2 = {
            p24: $('#p24').val(),
            p25: $('#p25').val(),
            p26: $('#p26').val(),
            p27: $('#p27').val(),
            p28: $('#p28').val(),
            p29: $('#p29').val(),
            p30: $('#p30').val(),
            p31: $('#p31').val(),
        };
        var ResultData = {
            p32: $('#p32').val(),
            p33: $('#p33').val(),
        };
	var isValid = true;

	if ($('#coordinationTable tbody .coordination-entry').length > 1) {
    	// Validar campos p14
   	$('#coordinationTable tbody tr').each(function() {
            var p14 = $(this).find('input[name="p14[]"]').val();

            if (p14 === '0') {
            	// Si está vacío, completar con '00000000'
            	if (confirm('El campo de teléfono fijo está vacío. ¿Desea rellenarlo con "00000000"?')) {
                $(this).find('input[name="p14[]"]').val('00000000');
            } else {
                alert('Por favor, complete el campo de teléfono fijo.');
                isValid = false;
                return false; // Detener la validación si el usuario decide no rellenar con ceros
            }
        }   else if (!/^2\d{7}$/.test(p14)) {
            	// Verificar que comience con '2' y tenga 8 dígitos
            	alert('El campo p14 debe comenzar con "2" y tener exactamente 8 dígitos.');
            	isValid = false;
            	return false; // Detener la validación si hay un error
            }
    	});


    	// Validar campos p15
    	$('#coordinationTable tbody tr').each(function() {
            var p15 = $(this).find('input[name="p15[]"]').val();

            if (p15 === '0') {
            // Preguntar al usuario si desea completar con '00000000'
            if (confirm('El campo de teléfono móvil está vacío. ¿Desea rellenarlo con "00000000"?')) {
                $(this).find('input[name="p15[]"]').val('00000000');
            } else {
                alert('Por favor, complete el campo de teléfono móvil (p15).');
                isValid = false;
                return false; // Detener la validación si el usuario decide no rellenar con ceros
            }
        }  else if (!/^[67]\d{7}$/.test(p15)) {
            	// Verificar que comience con '6' o '7' y tenga 8 dígitos
            	alert('El campo p15 debe comenzar con "6" o "7" y tener exactamente 8 dígitos.');
            	isValid = false;
            return false; // Detener la validación si hay un error
            }
    	});
	}
	// Validar campos p21
	if ($('#supportStaffTable tbody .coordination-entry').length > 0) {
        $('#supportStaffTable tbody tr').each(function() {
            var p21 = $(this).find('input[name=p21[]"]').val();

            if (p21 === '0') {
            // Preguntar al usuario si desea completar con '00000000'
            if (confirm('El campo de teléfono móvil está vacío. ¿Desea rellenarlo con "00000000"?')) {
                $(this).find('input[name="p21[]"]').val('00000000');
            } else {
                alert('Por favor, complete el campo de teléfono móvil (p21).');
                isValid = false;
                return false; // Detener la validación si el usuario decide no rellenar con ceros
            }
        }  else if (!/^2\d{7}$/.test(p21))  {
                // Verificar que comience con '6' o '7' y tenga 8 dígitos
                alert('El campo p21 debe comenzar con "2" y tener exactamente 8 dígitos.');
                isValid = false;
            return false; // Detener la validación si hay un error
            }
        });
	 $('#supportStaffTable tbody tr').each(function() {
            var p22 = $(this).find('input[name="p22[]"]').val();

            if (p22 === '0') {
            // Preguntar al usuario si desea completar con '00000000'
            if (confirm('El campo de teléfono móvil está vacío. ¿Desea rellenarlo con "00000000"?')) {
                $(this).find('input[name="p22[]"]').val('00000000');
            } else {
                alert('Por favor, complete el campo de teléfono móvil (p22).');
                isValid = false;
                return false; // Detener la validación si el usuario decide no rellenar con ceros
            }
        }  else if (!/^[67]\d{7}$/.test(p22)) {
                // Verificar que comience con '6' o '7' y tenga 8 dígitos
                alert('El campo p22 debe comenzar con "6" o "7" y tener exactamente 8 dígitos.');
                isValid = false;
            return false; // Detener la validación si hay un error
            }
        });
	}

	if (isValid) {
        // Empaquetar toda la información en un solo objeto
        var formData = {
            _token: $('input[name="_token"]').val(),  // Token CSRF
            form_id: $('input[name="form_id"]').val(),
            section1: headerData,
            section2: tableData,
            section3: supportTableData,
            section4: supportTableData2,
            section5: ResultData
        };
	 $.ajax({
            url: '<?php echo e(route("survey.store")); ?>', // Ruta del controlador que procesará el formulario
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                // Manejar la respuesta del servidor
                alert('Formulario enviado exitosamente');
                window.location.href = '<?php echo e(route("form.success")); ?>'; // Redirigir al éxito
            },
            error: function(xhr, status, error) {
                // Manejar errores
                console.error('Error en el envío del formulario:', error);
                alert('Error al enviar el formulario');
            }
        });
	}
    });

    // Manejar el evento de agregar nueva coordinación
    $('#add-coordination-btn').on('click', function() {
        // Crear un objeto jQuery a partir de la plantilla
        var $newRow = $(newCoordination);

        // Agregar la nueva fila al DataTable
        table.row.add($newRow[0]).draw(false);
    });
    // Plantilla para una nueva fila
    var newCoordination = `
    <tr class="coordination-entry">
        <td>
            <select class="form-select institution-select" name="p11[]" required>
                <option value="">Seleccione...</option>
                <option value="Minsal">Minsal</option>
                <option value="Alcaldía">Alcaldía</option>
                <option value="ADESCO">ADESCO</option>
                <option value="ONG">ONG</option>
                <option value="Otro">Otro</option>
            </select>
        </td>
        <td>
            <select class="form-select establishment-select" name="p12[]" style="display: none;" required>
                <option value="">Seleccione un establecimiento...</option>
            </select>
        </td>
        <td><input type="text" name="p13[]" class="form-control" required></td>
        <td><input type="tel" name="p14[]" class="form-control" required></td>
        <td><input type="tel" name="p15[]" class="form-control" required></td>
        <td><input type="email" name="p16[]" class="form-control" required></td>
        <td>
            <button type="button" class="btn btn-danger remove-row">Eliminar</button>
        </td>
    </tr>`;

    // Manejar la eliminación de filas
    $('#coordinationTable tbody').on('click', '.remove-row', function() {
    if (confirm("¿Estás seguro de que deseas eliminar esta fila?")) {
            // Obtener la fila actual donde se hizo clic en el botón "Eliminar"
            var $row = $(this).closest('tr');
	    // Si el DataTable está en modo responsive y tiene una fila child, buscar la fila padre
            if ($row.hasClass('child')) {
            	$row = $row.prev(); // La fila padre está antes de la fila .child
            }
            // Remover la fila del DataTable
            table.row($row).remove().draw(false);
	}
    });

     // Cargar establecimientos cuando se selecciona Minsal y se cambia el municipio o distrito
    $(document).on('change', '#p4, #p5, .institution-select', function() {
        var p4 = $('#p4').val(); // Obtén el valor del municipio seleccionado
        var p5 = $('#p5').val(); // Obtén el valor del distrito seleccionado
        var ins = $(this).closest('.coordination-entry').find('.institution-select').val();
        // Verifica si la institución seleccionada es Minsal y si hay valores en muni y distrito
        if (ins === 'Minsal' && p4 && p5) {

            var establecimiento = $(this).closest('.coordination-entry').find('.establishment-select');

            // Realiza la llamada AJAX para obtener los establecimientos
            $.ajax({
                url: '<?php echo e(route("household.visit.getEstablishments")); ?>',
                type: 'GET',
                data: {
                    p4: p4,         // Envía el valor de municipio
                    p5: p5  // Envía el valor de distrito
                },
                 success: function(data) {
                    console.log('Datos recibidos:', data);
                    // Asegúrate de limpiar el select y agregar una opción por defecto
                    establecimiento.empty().append('<option value="">Seleccione un establecimiento...</option>');

                    // Itera sobre los establecimientos recibidos y agrégalos al select
                    $.each(data, function(index, establishment) {
                        establecimiento.append('<option value="'+establishment.id+'">'+establishment.nombre+'</option>');
                    });

                    // Mostrar el select y remover cualquier estilo de ocultamiento
                    establecimiento.css('display', 'block');
                },
                error: function(xhr, status, error) {
                    console.error("Error al obtener los establecimientos: ", error);
                }
            });
        } else {
            // Si la institución no es Minsal, oculta el select de establecimiento
            $(this).closest('.coordination-entry').find('.establishment-select').hide();
        }
    });
    var supportCounter = 1; // Contador para el número de fila
    // Añadir nueva fila cuando sea necesario
    $('#add-support-btn').on('click', function() {
        var $newRow = $(getNewRowTemplate(supportCounter++));  // Asignar el número correspondiente
        var rowNode = supportTable.row.add($newRow).draw().node();  // Añadir fila a DataTable
        attachChangeEvent($(rowNode));  // Vincular el evento 'change' en la nueva fila
    });
     $('#supportStaffTable').on('click', '.remove-support-row', function() {
        // Obtener la fila principal que tiene la clase 'parent' (aunque el botón esté en la fila hija)
            if (confirm("¿Estás seguro de que deseas eliminar esta fila?")) {
            var $row = $(this).closest('tr');

            if ($row.hasClass('child')) {
                // Si es una fila hija, obtener la fila padre
                $row = $row.prev('.parent');
            }

            // Remover la fila del DataTable
            supportTable.row($row).remove().draw(false);  // Redibujar sin recargar toda la tabla

            // Recalcular los números de las filas restantes
            recalculateNumbers();
        }
    });
     function recalculateNumbers() {
        supportCounter = 1;  // Reiniciar el contador
        $('#supportStaffTable tbody tr').each(function() {
            $(this).find('input[name="p17[]"]').val(supportCounter);
            supportCounter++;
        });
    }
    
    // Función para adjuntar el evento change en los selects de cargo
    function attachChangeEvent($row) {
        $row.find('.cargo-select').on('change', function() {
            var cargoValue = $(this).val();

            // Mostrar/ocultar la columna "Especifique" si el valor es '7'
            if (cargoValue === '7') {
                // Mostrar la columna "Especifique"
                supportTable.column(4).visible(true).draw();  // Forzar redibujar la tabla
                // Habilitar el campo "Especifique" para la fila actual
                $(this).closest('tr').find('input[name="p20_[]"]').prop('disabled', false);
            } else {
                // Ocultar el campo "Especifique" si no es '7' en la fila actual
                $(this).closest('tr').find('input[name="p20_[]"]').prop('disabled', true);

                // Verificar si alguna otra fila tiene el valor '7'
                var anyOtherSelected = false;
                $('.cargo-select').each(function() {
                    if ($(this).val() == '7') {
                        anyOtherSelected = true;
                    }
                });

                // Si ninguna fila tiene el valor '7', ocultar la columna
                if (!anyOtherSelected) {
                    supportTable.column(4).visible(false).draw();  // Ocultar la columna y redibujar la tabla
                }
            }
        });
    }
    // Llamar la función de evento cuando se cargue la página
    attachChangeEvent($('#supportStaffTable tbody tr'));
    // Forzar que la columna esté oculta al cargar la página
    supportTable.column(4).visible(false).draw();

    function getNewRowTemplate(number) {
        return `
            <tr class="support-entry">
                <td><input type="text" name="p17[]" class="form-control" value="${number}" readonly></td>
                <td><input type="text" name="p18[]" class="form-control" required></td>
                <td>
		    <select id="p19[]" name="p19[]" class="form-control" required>
                	<option value="">Seleccione...</option>
                	<option value="1">Minsal</option>
                	<option value="2">Alcaldía</option>
                	<option value="3">ADESCO</option>
                	<option value="4">ONG</option>
                	<option value="5">Otro</option>
            	    </select>
		</td>
		<td>
                    <select id="p20[]" name="p20[]" class="form-control cargo-select" required>
                        <option value="">Seleccione...</option>
                        <option value="1">Médico</option>
                        <option value="2">Enfermera</option>
                        <option value="3">Inspector</option>
                        <option value="4">Promotor</option>
			<option value="5">Otro profesional de salud</option>
                        <option value="6">Líder</option>
                        <option value="7">Otro</option>
                    </select>
                </td>
		<td><input type="text" name="p20_[]" class="form-control" disabled></td>
                <td><input type="tel" name="p21[]" class="form-control" required></td>
                <td><input type="tel" name="p22[]" class="form-control" required></td>
                <td><input type="email" name="p23[]" class="form-control" required></td>
                <td><button type="button" class="btn btn-danger remove-support-row">Eliminar</button></td>
            </tr>`;
    }
});
document.addEventListener('DOMContentLoaded', function () {
    const submitButton = document.querySelector('button[type="submit"]');
    const p24 = document.getElementById('p24');
    const p28 = document.getElementById('p28');
    const labInfo = document.getElementById('labInfo');   // Contenedor de p25, p26, p27
    const labInfo2 = document.getElementById('labInfo2'); // Contenedor de p29, p30, p31

    // Función para validar y habilitar/deshabilitar campos ocultos
    function validateForm() {
        const requiredFields = document.querySelectorAll('[required]:not(.d-none [required])');
        let allFilled = true;

        requiredFields.forEach(field => {
            if (!field.value) {
                allFilled = false;
                field.classList.add('is-invalid'); // Agregar clase de error
            } else {
                field.classList.remove('is-invalid'); // Quitar clase de error
            }
        });

        submitButton.disabled = !allFilled; // Habilitar o deshabilitar el botón de envío
    }

    // Mostrar/Ocultar campos adicionales dependiendo de la selección de p24 (Laboratorio Clínico)
    p24.addEventListener('change', function () {
        if (p24.value === "1") {  // Si p24 es "Sí"
            labInfo.classList.remove('d-none');  // Mostrar el contenedor de p25, p26 y p27
            // Hacer p25 y p26 requeridos
            document.getElementById('p25').setAttribute('required', true);
            document.getElementById('p26').setAttribute('required', true);
            // Mostrar p27 pero sin hacerlo requerido
            document.getElementById('p27').classList.remove('d-none');
        } else {
            labInfo.classList.add('d-none');  // Ocultar el contenedor
            // Quitar el atributo required de p25 y p26
            document.getElementById('p25').removeAttribute('required');
            document.getElementById('p26').removeAttribute('required');
            // Asegurar que p27 esté oculto
            document.getElementById('p27').classList.add('d-none');
        }
        validateForm();
    });

    // Mostrar/Ocultar campos adicionales dependiendo de la selección de p28 (Promotor de Salud)
    p28.addEventListener('change', function () {
        if (p28.value === "1") {  // Si p28 es "Sí"
            labInfo2.classList.remove('d-none');  // Mostrar el contenedor de p29, p30 y p31
            // Hacer p29 y p30 requeridos
            document.getElementById('p29').setAttribute('required', true);
            document.getElementById('p30').setAttribute('required', true);
            // Mostrar p31 pero sin hacerlo requerido
            document.getElementById('p31').classList.remove('d-none');
        } else {
            labInfo2.classList.add('d-none');  // Ocultar el contenedor
            // Quitar el atributo required de p29 y p30
            document.getElementById('p29').removeAttribute('required');
            document.getElementById('p30').removeAttribute('required');
            // Asegurar que p31 esté oculto
            document.getElementById('p31').classList.add('d-none');
        }
        validateForm();
    });

    // Validar el formulario al cambiar cualquier campo
    document.querySelectorAll('input, select').forEach(input => {
        input.addEventListener('input', validateForm);
    });

    // Añadir evento de input a todos los campos requeridos
    const requiredFields = document.querySelectorAll('[required]');
    requiredFields.forEach(field => {
        field.addEventListener('input', validateForm);
    });

    // Validar el formulario al cargar la página
    validateForm();
});

</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EncuestaProject/resources/views/survey/form5.blade.php ENDPATH**/ ?>