<?php $__env->startSection('content'); ?>
<div class="container">
    <h1>Agregar Household</h1>
    <form method="POST" action="<?php echo e(route('households.store')); ?>">
        <?php echo csrf_field(); ?>
        
        <div class="mb-3">
            <label for="correlativo_segmento" class="form-label">Correlativo Segmento</label>
            <select class="form-control select2" id="correlativo_segmento" name="correlativo_segmento">
                <?php $__currentLoopData = $segments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $segment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($segment->correlativo_segmento); ?>"><?php echo e($segment->correlativo_segmento); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="mb-3">
            <label for="region" class="form-label">Región</label>
            <select class="form-control" id="region" name="region">
                <?php $__currentLoopData = $regions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $region): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($region->codigo); ?>"><?php echo e($region->nombre); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="mb-3">
            <label for="departamento" class="form-label">Departamento</label>
            <select class="form-control" id="departamento" name="departamento">
                <!-- Las opciones se cargarán de forma dinámica según la región seleccionada -->
            </select>
        </div>

        <!-- Otros campos del formulario aquí -->

        <button type="submit" class="btn btn-primary">Agregar</button>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function() {
        $('#region').change(function() {
            let regionCode = $(this).val();
            
            // Cargar departamentos basados en la región seleccionada
            $.ajax({
                url: '/api/departamentos/by-region', // Ruta a la API que devuelve los departamentos
                data: { region: regionCode },
                success: function(data) {
                    $('#departamento').empty();
                    $.each(data, function(key, value) {
                        $('#departamento').append('<option value="'+ value.codigo +'">'+ value.nombre +'</option>');
                    });
                }
            });
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EncuestaProject/resources/views/households/create.blade.php ENDPATH**/ ?>