<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request;
use App\Http\Controllers\{
    HomeController,
    HouseholdController,
    HouseholdMemberController,
    HouseholdTeamController,
    UserController,
    RoleController,
    TeamController,
    Form1Controller,
    Form2Controller,
    Form3Controller,
    AdminController,
    ScreenLockController,
    KMLController,
    MapController,
    ConditionController,
    OptionController,
    FormController,
    FormSectionController,
    SectionQuestionController,
    SurveyController,
    QuestionController,
    InterviewerHouseholdController,
    AssignmentController,
    SegmentUserController,
    HouseholdVisitController,
};
Auth::routes();
// Rutas protegidas por el middleware auth y checkrole:admin
Route::middleware(['auth', 'checkrole:Administrador'])->group(function () {
    Route::get('/admin', [AdminController::class, 'index'])->name('admin.index');
    Route::resource('users', UserController::class);
    Route::resource('questions', QuestionController::class);
    Route::resource('roles', RoleController::class);
    Route::get('/households', [HouseholdController::class, 'index'])->name('households');
    Route::resource('households', HouseholdController::class);
    Route::get('/households/create', [HouseholdController::class, 'create'])->name('households.create');
    Route::resource('household_members', HouseholdMemberController::class);
    Route::resource('household_teams', HouseholdTeamController::class);
    Route::get('/household_teams', [HouseholdTeamController::class, 'index'])->name('household_teams.index');
    Route::get('/household_teams/reassign/{id}', [HouseholdTeamController::class, 'reassign'])->name('household_teams.reassign');
    Route::post('/household_teams/reassign/{id}', [HouseholdTeamController::class, 'storeReassign'])->name('household_teams.storeReassign');
    Route::get('/household_teams/show_reassignments/{correlativo_segmento}', [HouseholdTeamController::class, 'showReassignments'])->name('household_teams.showReassignments');
    Route::post('households/import', [HouseholdController::class, 'import'])->name('households.import');
    Route::post('household_members/import', [HouseholdMemberController::class, 'import'])->name('household_members.import');
    Route::get('/users/create', [UserController::class, 'create'])->name('users.create');
    Route::post('/users', [UserController::class, 'store'])->name('users.store');
    Route::resource('/teams', TeamController::class);
    Route::get('/questions/create', [QuestionController::class, 'create'])->name('questions.create');
    Route::post('/questions', [QuestionController::class, 'store'])->name('questions.store');
    Route::get('/conditions/get/{questionId}', [ConditionController::class, 'getConditionsByQuestion'])->name('conditions.get');
    Route::get('/conditions/create', [ConditionController::class, 'create'])->name('conditions.create');
    Route::post('/conditions/store', [ConditionController::class, 'store'])->name('conditions.store');
    Route::get('/options/create', [OptionController::class, 'create'])->name('options.create');
    Route::post('/options', [OptionController::class, 'store'])->name('options.store');
    Route::get('/options/{question}/list', [OptionController::class, 'listOptions'])->name('options.list');
    Route::resource('forms', FormController::class);
    Route::resource('form_sections', FormSectionController::class);
    Route::resource('section_questions', SectionQuestionController::class);
    Route::get('/get-orders/{householdId}', [HouseholdController::class, 'getOrders']);
    Route::get('/get-numbers/{householdId}', [HouseholdController::class, 'getNumbers']);
    Route::get('/questions/{id}', [QuestionController::class, 'checkType']);
    Route::delete('/conditions/delete/{id}', [ConditionController::class, 'destroy'])->name('conditions.delete');
    Route::resource('segment-user', SegmentUserController::class);
    Route::get('/segment-user', [SegmentUserController::class, 'index'])->name('segment_user.index');
    Route::get('/segment-user/create', [SegmentUserController::class, 'create'])->name('segment_user.create');
    Route::post('/segment-user', [SegmentUserController::class, 'store'])->name('segment_user.store');
    Route::delete('segment-user/{id}', [SegmentUserController::class, 'destroy'])->name('segment_user.destroy');

});
// Rutas para el bloqueo de pantalla
Route::get('/screen-lock', [ScreenLockController::class, 'showLockScreen'])->name('screen.lock');
Route::post('/unlock', [ScreenLockController::class, 'unlock'])->name('unlock');

// Rutas protegidas por el middleware auth:sanctum y verified
Route::middleware(['auth:sanctum', 'verified'])->group(function () {
    Route::get('/', [HomeController::class, 'index'])->name('home');
    Route::get('/kml/map', [KMLController::class, 'showMap'])->name('kml.map');
    Route::post('/kml/process', [KMLController::class, 'processKML'])->name('kml.process');
    Route::get('/form1', [Form1Controller::class, 'index'])->name('form1');
    Route::get('/form2', [Form2Controller::class, 'index'])->name('form2');
    Route::get('/form3', [Form3Controller::class, 'index'])->name('form3');
    Route::post('/form1/buscar', [Form1Controller::class, 'buscar'])->name('form1.buscar');
    Route::get('/form1/add', [Form1Controller::class, 'add'])->name('form1.add');
    Route::get('/maps', [MapController::class, 'index'])->name('maps.index');
    Route::get('/maps/create', [MapController::class, 'create'])->name('maps.create');
    Route::post('/maps', [MapController::class, 'store'])->name('maps.store');
    Route::get('/households/search', [HouseholdController::class, 'search'])->name('households.search');
    // Ruta para mostrar el formulario
    Route::get('/survey/form1', [QuestionController::class, 'index'])->name('survey.form1');
    Route::get('/households/{correlativoSegmento}/orden_vivienda', [HouseholdController::class, 'getOrdenVivienda']);
    Route::get('/households/{ordenVivienda}/numero_vivienda', [HouseholdController::class, 'getNumeroVivienda']);
    
    // Ruta para mostrar el formulario de la encuesta
    Route::get('/survey/form/{form_id}', [SurveyController::class, 'show'])->name('survey.show');
    // Ruta para procesar el envío del formulario de la encuesta
    Route::post('/survey/form/{form_id}/submit', [SurveyController::class, 'submit'])->name('survey.submit');

    Route::get('/api/departamentos/by-region', [HouseholdController::class, 'getDepartamentosByRegion']);
    Route::get('/get-filtered-options', [SurveyController::class, 'getFilteredOptions'])->name('get.filtered.options');
    Route::get('/household/visit/get-establishments', [SurveyController::class, 'getEstablishments'])->name('household.visit.getEstablishments');
});

// Rutas protegidas por el middleware auth y checkrole:admin
Route::middleware(['auth', 'checkrole:Encuestador/a'])->group(function () {
    Route::get('/hogares/miembros', [InterviewerHouseholdController::class, 'index'])->name('miembros.index');
});

Route::middleware(['auth', 'checkrole:Supervisor/a'])->group(function () {
   Route::get('/assignments/create', [AssignmentController::class, 'showForm'])->name('assignments.create');
   Route::post('/assignments/store', [AssignmentController::class, 'assign'])->name('assignments.store');
});

Route::middleware(['auth', 'checkrole:Coordinador/a'])->group(function () {
   Route::get('/household-visit/segment-details/{id}', [HouseholdVisitController::class, 'getSegmentDetails'])->name('household-visit.segment-details');
   Route::get('/survey/{id}', [SurveyController::class, 'show'])->name('survey.show');
   Route::post('/store', [SurveyController::class, 'store'])->name('survey.store');
   Route::get('/form-success', [SurveyController::class, 'success'])->name('form.success');
   Route::get('/answers/data', [AnswersController::class, 'getData'])->name('answers.data');
   Route::get('/coordinador/view/{correlativo_segmento}', [SurveyController::class, 'cview'])->name('coordinador.view');
   Route::get('/households/{correlativoSegmento}', [HouseholdVisitController::class, 'getHouseholds']);
   Route::get('/household-visit/segment-detail/{id}', [HouseholdVisitController::class, 'getSegmentDetail'])->name('household-visit.segment-detail');
   // Ruta para obtener los detalles de un segmento específico
   Route::get('/household-visit/segment-details/{segmentId}', [HouseholdController::class, 'getSegmentDetails'])->name('segment.details');

   // Ruta para obtener los miembros de un hogar específico
   Route::get('/household-visit/household-members/{householdId}', [HouseholdController::class, 'getHouseholdMembers'])->name('household.members');
   Route::get('/household-visit/get-user-id', [HouseholdController::class, 'getUserId']);
   Route::post('/household-visit/assign-household', [HouseholdController::class, 'assignHousehold']);
   Route::get('/household-visit/check-assignment', [HouseholdController::class, 'checkAssignment']);
   Route::get('/household-visit/get-replacements/{segmentId}', [HouseholdController::class, 'getReplacements'])->name('household.getReplacements');
   Route::post('/household-visit/discard-household', [HouseholdController::class, 'discardHousehold'])->name('household.discard');
   Route::post('/household/signal/{householdId}', [HouseholdController::class, 'storeSignal']);

});
