<div class="col-md-{{ $columnWidth }} d-flex align-items-start">
    <!-- Div para la numeración -->
    <div class="question-number me-2" style="width: 30px;">
        @php
            // Obtener el sectionQuestion correspondiente
            $sectionQuestion = $sectionQuestions->where('section_id', $section->id)->firstWhere('question_id', $question->id);
        @endphp

        @if($sectionQuestion)
            <span class="form-label" style="font-weight: bold;">{{ $sectionQuestion->question_enum }}</span> <!-- Numeración -->
        @endif
    </div>

    <!-- Contenedor del label e input -->
    <div class="flex-grow-1">
        <label for="{{ $question->question_code }}" class="form-label">
            {{ $question->question_text }}
        </label>

        @if($question->question_type == 'text')
            <input type="text" name="{{ $question->question_code }}" id="{{ $question->question_code }}" class="form-control" @if($question->is_required) required @endif>
        @elseif($question->question_type == 'date')
            <input type="date" name="{{ $question->question_code }}" id="{{ $question->question_code }}" class="form-control" @if($question->is_required) required @endif>
        @elseif($question->question_type == 'time')
            <input type="text" name="{{ $question->question_code }}" id="{{ $question->question_code }}" class="form-control" placeholder="HH:MM AM/PM" @if($question->is_required) required @endif>
        @elseif($question->question_type == 'numeric')
            <input type="number" name="{{ $question->question_code }}" id="{{ $question->question_code }}" class="form-control" @if($question->is_required) required @endif>
        @elseif($question->question_type == 'radio')
            @foreach($question->options as $option)
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="{{ $question->question_code }}" id="{{ $question->question_code }}_{{ $option->option_value }}">
                    <label class="form-check-label" for="{{ $question->question_code }}_{{ $option->option_value }}">
                        {{ $option->option_text }}
                    </label>
                </div>
            @endforeach
        @elseif($question->question_type == 'checkbox')
            @foreach($question->options as $option)
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" name="{{ $question->question_code }}[]" id="{{ $question->question_code }}_{{ $option->option_value }}">
                    <label class="form-check-label" for="{{ $question->question_code }}_{{ $option->option_value }}">
                        {{ $option->option_text }}
                    </label>
                </div>
            @endforeach
        @elseif($question->question_type == 'select')
            <select name="{{ $question->question_code }}" id="{{ $question->question_code }}" class="form-select" @if($question->is_required) required @endif>
                <option value="" disabled selected>Selecciona una opción</option>
                @foreach($question->options as $option)
                    <option value="{{ $option->option_value }}">{{ $option->option_text }}</option>
                @endforeach
            </select>
        @elseif($question->question_type == 'textarea')
            <textarea name="{{ $question->question_code }}" id="{{ $question->question_code }}" class="form-control" @if($question->is_required) required @endif></textarea>
        @endif
    </div>
</div>

