<!-- resources/views/survey/options/create.blade.php -->
@extends('layouts.main')

@section('content')
<div class="container">
    <h1>Add Options to Question</h1>

    <form action="{{ route('options.store') }}" method="POST">
        @csrf
        <div class="form-group">
            <label for="question_id">Select Question</label>
            <select name="question_id" id="question_id" class="form-control">
                <option value="">Choose a question...</option>
                @foreach($questions as $question)
                    <option value="{{ $question->id }}">{{ $question->question_text }}</option>
                @endforeach
            </select>
        </div>

        <div class="form-group">
            <label for="option_text">Option Text</label>
            <input type="text" name="option_text" id="option_text" class="form-control">
        </div>

        <div class="form-group">
            <label for="option_value">Option Value</label>
            <input type="text" name="option_value" id="option_value" class="form-control">
        </div>

        <div class="form-group form-check">
            <input type="checkbox" name="is_other" id="is_other" class="form-check-input">
            <label for="is_other" class="form-check-label">This is an "Other" option</label>
        </div>

        <button type="submit" class="btn btn-primary">Add Option</button>
    </form>

    <h2 class="mt-4">Existing Options</h2>
    <table class="table table-striped mt-3">
        <thead>
            <tr>
                <th>Option Text</th>
                <th>Option Value</th>
            </tr>
        </thead>
        <tbody id="options-list">
            <tr>
                <td colspan="2">Please select a question to see its options.</td>
            </tr>
        </tbody>
    </table>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const questionSelect = document.getElementById('question_id');
    const optionsList = document.getElementById('options-list');
    const isOtherCheckbox = document.getElementById('is_other');
    const optionValueInput = document.getElementById('option_value');

    questionSelect.addEventListener('change', function() {
        const questionId = this.value;

        if (questionId) {
            fetch(`/options/${questionId}/list`)
                .then(response => response.json())
                .then(data => {
                    optionsList.innerHTML = '';

                    if (data.length > 0) {
                        data.forEach(option => {
                            optionsList.innerHTML += `
                                <tr>
                                    <td>${option.option_text}</td>
                                    <td>${option.option_value}</td>
                                </tr>
                            `;
                        });
                    } else {
                        optionsList.innerHTML = '<tr><td colspan="2">No options found for this question.</td></tr>';
                    }
                });
        } else {
            optionsList.innerHTML = '<tr><td colspan="2">Please select a question to see its options.</td></tr>';
        }
    });

    isOtherCheckbox.addEventListener('change', function() {
        if (this.checked) {
            optionValueInput.value = '';
            optionValueInput.disabled = true;
        } else {
            optionValueInput.disabled = false;
        }
    });
});
</script>
@endsection
