@extends('layouts.main')

@section('content')
<div class="container">
    <h1>Secciones del Formulario</h1>
    <a href="{{ route('form_sections.create') }}" class="btn btn-primary mb-3">Agregar Nueva Sección</a>

    @if (session('success'))
    <div class="alert alert-success">
        {{ session('success') }}
    </div>
    @endif

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>ID</th>
                <th>Título de la Sección</th>
                <th>Descripción</th>
                <th>Orden</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($formSections as $section)
            <tr>
                <td>{{ $section->id }}</td>
                <td>{{ $section->section_name }}</td>
                <td>{{ $section->description }}</td>
                <td>{{ $section->section_order }}</td>
                <td>
                    <a href="{{ route('form_sections.edit', $section->id) }}" class="btn btn-warning btn-sm">Editar</a>
                    <form action="{{ route('form_sections.destroy', $section->id) }}" method="POST" style="display:inline;">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-sm">Eliminar</button>
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
