
@extends('layouts.main')

@section('content')
    <!-- Enlace al archivo CSS de estilos -->
    <link rel="stylesheet" href="{{ asset('css/survey.css') }}">
    
    <div class="sticky-icon">
    @foreach($form->formSections as $section)
    	<a href="#section-{{ $section->id }}" class="section-link"><i class='bx bx-chevrons-left'></i> {{ $section->section_name }} </a>
    	    <!-- @foreach($section->questions as $question)
            	<a href="#question-{{ $question->id }}" class="question-link"><i class="fas fa-arrow-right"></i> {{ $question->question_text }} </a>
            @endforeach -->

    	@endforeach
    </div>

    <div class="sticky-icon2">
    	<button id="view-drafts" class="draft-button">View Drafts</button>
    	<div id="draft-list" class="draft-list">
            <!-- Aquí se cargarán los borradores -->
    	</div>
    </div>


    <div class="container">
	<div class="form-container">
        <h2 class="tittle">{{ $form->form_name }}</h2> <!-- Nombre del formulario -->
        <form method="POST" id="form1"  action="{{ route('survey.submit', ['form_id' => $form->id]) }}" onsubmit="localStorage.removeItem(`form_${{{ $form->id }}}_draft`);">
            @csrf

            @foreach($form->formSections as $section)
                <div id="section-{{ $section->id }}" class="row sub survey-section">
		    <h3 class="subtitle">{{ $section->section_name }}</h3>
		</div>
                <div class="row">
                    @php
                        $currentWidth = 0;
                    @endphp

                    @foreach($section->questions->sortBy('question_order') as $index => $question)
                        @php
                            // Obtener la clase de la pregunta
                            $columnWidth = 0;
                            if (strpos($question->style_class, 'col-md-12') !== false) {
                                $columnWidth = 12;
                            } elseif (strpos($question->style_class, 'col-md-8') !== false) {
                                $columnWidth = 8;
                            } elseif (strpos($question->style_class, 'col-md-6') !== false) {
                                $columnWidth = 6;
                            } elseif (strpos($question->style_class, 'col-md-4') !== false) {
                                $columnWidth = 4;
                            } elseif (strpos($question->style_class, 'col-md-3') !== false) {
                                $columnWidth = 3;
                            }

                            // Verificar si el ancho acumulado más el ancho de la siguiente pregunta excede 12
                            if ($currentWidth + $columnWidth > 12) {
                                echo '</div><div class="row">'; // Cerrar la fila actual y abrir una nueva
                                $currentWidth = 0; // Reiniciar el ancho acumulado
                            }

                            // Acumular el ancho actual
                            $currentWidth += $columnWidth;
                        @endphp
                    <div id="question-{{ $question->id }}" class="{{ $question->style_class }} question-item survey-question">
			<div class="d-flex">
                            <div class="question-number">{{ $index + 1 }}</div>
                            <div class="question-label">
                            	<label for="{{ $question->question_code }}">{{ $question->question_text }}</label>

                            	@if($question->question_type == 'text')
                                    <input type="text" name="{{ $question->question_code }}" id="{{ $question->question_code }}" class="form-control" @if($question->is_required) required @endif>
                            	@elseif($question->question_type == 'radio')
                                    @foreach($question->options as $option)
                                    	<div class="form-check">
                                            <input class="form-check-input" type="radio" name="{{ $question->question_code }}" id="{{ $question->question_code }}_{{ $option->option_value }}" value="{{ $option->option_value }}">
                                            <label class="form-check-label" for="{{ $question->question_code }}_{{ $option->option_value }}">
                                                {{ $option->option_text }}
                                            </label>
                                    	</div>
                                    @endforeach
                            	@elseif($question->question_type == 'checkbox')
                                    @foreach($question->options as $option)
                                       	<div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="{{ $question->question_code }}[]" id="{{ $question->question_code }}_{{ $option->option_value }}" value="{{ $option->option_value }}" @if($question->is_required) required @endif>
                                            <label class="form-check-label" for="{{ $question->question_code }}_{{ $option->option_value }}"">
                                              	{{ $option->option_text }}
                                            </label>
                                    	</div>
                                     @endforeach
                            	@elseif($question->question_type == 'select')
                                    <select name="{{ $question->question_code }}" id="{{ $question->question_code }}" class="form-control" @if($question->is_required) required @endif>
                                    @if($question->question_code == 'correlativo_segmento')
                                        @foreach($segments as $segment)
                                            <option value="{{ $segment->id }}">{{ $segment->correlativo_segmento }}</option>
                                        @endforeach
                                    @else
                                        @foreach($question->options as $option)
                                            <option value="{{ $option->option_value }}">{{ $option->option_text }}</option>
                                        @endforeach
                                    @endif
                                </select>
			    @if($question->question_type == 'matrix')
    <table class="table table-bordered">
        <thead>
            <tr>
                <th></th>
                @foreach($question->matrixColumns as $column)
                    <th>{{ $column->column_text }}</th>
                @endforeach
            </tr>
        </thead>
        <tbody>
            @foreach($question->matrixRows as $row)
                <tr>
             		   <td>{{ $row->row_text }}</td>
                 		    @foreach($question->matrixColumns as $column)
                   		<td>
                   		   <input type="radio" name="matrix_{{ $question->id }}[{{ $row->id }}]" value="{{ $column->column_text }}"
                              		@if($column->has_other) 
          				onclick="toggleOtherField('{{ $row->id }}')"
                               		@endif
                           		    >
                          		    @if($column->has_other)
                              		<input type="text" id="other_field_{{ $row->id }}" name="other_matrix_{{ $row->id }}" class="form-control mt-2" style="display: none;">
                            		    @endif
                         		</td>
                    		    @endforeach
                		    </tr>
            			@endforeach
        			</tbody>
    			   </table
			   @endif

                            @elseif($question->question_type == 'textarea')
                                <textarea name="{{ $question->question_code }}" id="{{ $question->question_code }}" class="form-control" @if($question->is_required) required @endif></textarea>
                            @endif
                            </div>
                       </div>
		</div>	
                @endforeach
		</div> <!-- Cierre de la fila actual -->
            @endforeach

            <div class="text-end">
    		<button type="button" id="save-draft" class="btn btn-secondary">Guardar Borrador</button>
    		<button type="submit" class="btn btn-primary" id="submit-button">Enviar</button>
	    </div>

        </form>
	</div>
    </div>
     <script>
    function toggleOtherField(rowId) {
        const otherField = document.getElementById('other_field_' + rowId);
        otherField.style.display = otherField.style.display === 'none' ? 'block' : 'none';
    }
    </script>
    <script>
	document.getElementById('save-draft').addEventListener('click', function() {
    // Crear un identificador único para el borrador
    const draftId = 'draft_' + new Date().getTime();
    
    // Obtenemos todos los elementos del formulario
    const formElements = document.querySelectorAll('#form1 input, #form1 select, #form1 textarea');
    let draftData = {};

    formElements.forEach(element => {
        draftData[element.name || element.id] = element.value;
    });

    // Guardar el borrador en localStorage
    localStorage.setItem(draftId, JSON.stringify(draftData));
    alert('Borrador guardado localmente');

    // Actualizar la lista de borradores
    updateDraftList();
});

function updateDraftList() {
    const draftList = document.getElementById('draft-list');
    draftList.innerHTML = ''; // Limpiar la lista

    for (let i = 0; i < localStorage.length; i++) {
        const key = localStorage.key(i);
        if (key.startsWith('draft_')) {
            const listItem = document.createElement('a');
            listItem.href = "#";
            listItem.textContent = key; // Muestra el ID como texto, puedes modificar esto
            listItem.addEventListener('click', function() {
                loadDraft(key);
            });
            draftList.appendChild(listItem);
        }
    }
}

// Cargar un borrador en el formulario
function loadDraft(draftId) {
    const draftData = JSON.parse(localStorage.getItem(draftId));
    const formElements = document.querySelectorAll('#form1 input, #form1 select, #form1 textarea');

    formElements.forEach(element => {
        if (draftData[element.name || element.id]) {
            element.value = draftData[element.name || element.id];
        }
    });

    alert('Borrador cargado');
}

// Mostrar/Ocultar la lista de borradores
document.getElementById('view-drafts').addEventListener('click', function() {
    const draftList = document.getElementById('draft-list');
    draftList.style.display = draftList.style.display === 'block' ? 'none' : 'block';
});

// Cargar la lista de borradores al cargar la página
window.addEventListener('load', updateDraftList);

	document.querySelectorAll('.sticky-icon a').forEach(anchor => {
	    anchor.addEventListener('click', function(e) {
	        e.preventDefault();

	        const targetId = this.getAttribute('href').substring(1);
	        const targetElement = document.getElementById(targetId);

	        if (targetElement) {
	            targetElement.scrollIntoView({ behavior: 'smooth' });
	        }
	    });
	});

        document.getElementById('correlativo_segmento').addEventListener('change', function() {
            const segmentId = this.value;

            fetch(`/get-filtered-options?segment_id=${segmentId}`)
                .then(response => response.json())
                .then(data => {
                    // Update regions
                    const regionSelect = document.getElementById('region');
                    regionSelect.innerHTML = '<option value="">Seleccione una región</option>';
                    data.regions.forEach(region => {
                        regionSelect.innerHTML += `<option value="${region.id}">${region.name}</option>`;
                    });
                    regionSelect.disabled = false;

                    // Update departments
                    const departmentSelect = document.getElementById('department');
                    departmentSelect.innerHTML = '<option value="">Seleccione un departamento</option>';
                    data.departments.forEach(dpto => {
                        departmentSelect.innerHTML += `<option value="${dpto.id}">${dpto.name}</option>`;
                    });
                    departmentSelect.disabled = false;

                    // Update municipalities
                    const municipalitySelect = document.getElementById('municipio');
                    municipalitySelect.innerHTML = '<option value="">Seleccione un municipio</option>';
                    data.municipios.forEach(muni => {
                        municipalitySelect.innerHTML += `<option value="${muni.id}">${muni.name}</option>`;
                    });
                    municipalitySelect.disabled = false;

                    // Update districts
                    const districtSelect = document.getElementById('distrito');
                    districtSelect.innerHTML = '<option value="">Seleccione un distrito</option>';
                    data.distritos.forEach(distrito => {
                        districtSelect.innerHTML += `<option value="${distrito.id}">${distrito.name}</option>`;
                    });
                    districtSelect.disabled = false;
                });
        });

    	// Required fields code
        document.addEventListener('DOMContentLoaded', function () {
            const submitButton = document.querySelector('button[type="submit"]');
            const requiredFields = document.querySelectorAll('[required]');

            function validateForm() {
                let allFilled = true;
                requiredFields.forEach(field => {
                    if (!field.value) {
                        allFilled = false;
                        field.classList.add('is-invalid');
                    } else {
                        field.classList.remove('is-invalid');
                    }
                });
                submitButton.disabled = !allFilled;
            }

            requiredFields.forEach(field => {
                field.addEventListener('input', validateForm);
            });

            validateForm(); // Ejecutar la validación al cargar la página
        });
    </script>

@endsection
