
@extends('layouts.main')

@section('content')
    <!-- Enlace al archivo CSS de estilos -->
    <link rel="stylesheet" href="{{ asset('css/survey.css') }}">

    <div class="container">
	<div class="form-container">
	<button class="nav-button" id="nav-toggle">
            <i class='bx bx-menu'></i> Navegación
    	</button>

    	<!-- Barra lateral -->
    	<div class="sidebar" id="sidebar">
	    <!-- Botón de cierre dentro de la barra lateral -->
	    <button class="close-button" id="closeButton">
	        <i class='bx bx-x'></i> Cerrar
	    </button>

            @foreach($form->formSections as $section)
            	<div class="section-header">
                    <a href="#section-{{ $section->id }}" class="section-link">
                    	<i class='bx bx-chevron-right'></i> {{ $section->section_name }}
                    </a>
                	<i class="bx bx-chevron-down expand-btn"></i>
            	</div>
            	<div class="subsection" style="display: none;">
                    @foreach($section->questions as $question)
                    	<a href="#question-{{ $question->id }}" class="question-link">
                            <i class='bx bx-right-arrow-alt'></i> {{ $question->question_text }}
                    	</a>
               	    @endforeach
            	</div>
            @endforeach
    	</div>

        <h2 class="tittle">{{ $form->form_name }}</h2> <!-- Nombre del formulario -->
        <form method="POST" id="form1"  action="{{ route('survey.submit', ['form_id' => $form->id]) }}" onsubmit="localStorage.removeItem(`form_${{{ $form->id }}}_draft`);">
            @csrf

            @foreach($form->formSections as $section)
                <div id="section-{{ $section->id }}" class="row sub survey-section">
		    <h3 class="subtitle">{{ $section->section_name }}</h3>
		</div>
                <div class="row">
                    @php
                        $currentWidth = 0;
                    @endphp

                    @foreach($section->questions->sortBy('question_order') as $index => $question)
                        @php
                            // Obtener la clase de la pregunta
                            $columnWidth = 0;
                            if (strpos($question->style_class, 'col-md-12') !== false) {
                                $columnWidth = 12;
                            } elseif (strpos($question->style_class, 'col-md-8') !== false) {
                                $columnWidth = 8;
                            } elseif (strpos($question->style_class, 'col-md-6') !== false) {
                                $columnWidth = 6;
                            } elseif (strpos($question->style_class, 'col-md-4') !== false) {
                                $columnWidth = 4;
                            } elseif (strpos($question->style_class, 'col-md-3') !== false) {
                                $columnWidth = 3;
                            }

                            // Verificar si el ancho acumulado más el ancho de la siguiente pregunta excede 12
                            if ($currentWidth + $columnWidth > 12) {
                                echo '</div><div class="row">'; // Cerrar la fila actual y abrir una nueva
                                $currentWidth = 0; // Reiniciar el ancho acumulado
                            }

                            // Acumular el ancho actual
                            $currentWidth += $columnWidth;
                        @endphp
                    <div id="question-{{ $question->id }}" class="{{ $question->style_class }} question-item survey-question" data-question-id="{{ $question->id }}"
     			data-question-type="{{ $question->question_type }}">
			<div class="d-flex">
			@if($question->question_type != 'note')
                             <div class="question-number">
                                <!-- Aquí mostramos el question_enum -->
                                @php
                                // Buscamos el sectionQuestion que coincide tanto con el question_id como con el section_id
                                $sectionQuestion = $sectionQuestions->where('section_id', $section->id)->firstWhere('question_id', $question->id);
                                @endphp

                                @if($sectionQuestion)
                                    {{ $sectionQuestion->question_enum }}
                                @endif
                            </div>
                            <div class="question-label">
                                <label for="{{ $question->question_code }}">{{ $question->question_text }}</label>
                            </div>
			   
			@endif
			@if($question->question_type == 'note')
                	    <!-- Mostrar solo el texto de la nota como encabezado -->
                	    <h4 class="note-header">{{ $question->question_text }}</h4>
            		@else
                            	@if($question->question_type == 'text')
                                    <input type="text" name="{{ $question->question_code }}" id="{{ $question->question_code }}" class="form-control" @if($question->is_required) required @endif>
                            	@elseif($question->question_type == 'note')
    				    <h4 class="note-header">{{ $question->question_text }}</h4>
				@elseif($question->question_type == 'date')
    				    <input type="date" name="{{ $question->question_code }}" id="{{ $question->question_code }}" class="form-control" @if($question->is_required) required  @endif  pattern="\d{2}/\d{2}/\d{4}" placeholder="dd/mm/aaaa">
				@elseif($question->question_type == 'numeric')
                                    <input type="number" name="{{ $question->question_code }}" id="{{ $question->question_code }}" class="form-control" @if($question->is_required) required @endif> 
				@elseif($question->question_type == 'range')
				    <input type="range" name="{{ $question->question_code }}" id="{{ $question->question_code }}" class="form-range" min="0" max="10" value="5" step="1">
				    <!-- Números del rango -->
				    <div class="range-labels">
				        @for ($i = 0; $i <= 10; $i++)
				            <span style="position: absolute; left: {{ $i * 10 }}%; transform: translateX(-50%);">{{ $i }}</span>
				        @endfor
				    </div>
				@elseif($question->question_type == 'radio')
                                    @foreach($question->options as $option)
                                    	<div class="form-check">
                                            <input class="form-check-input" type="radio" name="{{ $question->question_code }}" id="{{ $question->question_code }}_{{ $option->option_value }}" value="{{ $option->option_value }}">
                                            <label class="form-check-label" for="{{ $question->question_code }}_{{ $option->option_value }}">
                                                {{ $option->option_text }}
                                            </label>
                                    	</div>
                                    @endforeach
                            	@elseif($question->question_type == 'checkbox')
                                    @foreach($question->options as $option)
                                       	<div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="{{ $question->question_code }}[]" id="{{ $question->question_code }}_{{ $option->option_value }}" value="{{ $option->option_value }}" @if($question->is_required) required @endif>
                                            <label class="form-check-label" for="{{ $question->question_code }}_{{ $option->option_value }}">
                                              	{{ $option->option_text }}
                                            </label>
                                    	</div>
                                     @endforeach
                            	@elseif($question->question_type == 'select')
                                    <select name="{{ $question->question_code }}" id="{{ $question->question_code }}" class="form-control" @if($question->is_required) required @endif>
                                    <option value="" disabled selected>Selecciona una opción</option>
				    @if($question->question_code == 'correlativo_segmento')
                                        @foreach($segments as $segment)
                                            <option value="{{ $segment->id }}">{{ $segment->correlativo_segmento }}</option>
                                        @endforeach
                                    @else
                                        @foreach($question->options as $option)
                                            <option value="{{ $option->option_value }}">{{ $option->option_text }}</option>
                                        @endforeach
                                    </select>
				    @endif
			        @elseif($question->question_type == 'textarea')
                                    <textarea name="{{ $question->question_code }}" id="{{ $question->question_code }}" class="form-control" @if($question->is_required) required @endif></textarea>
                            	@endif
                            </div>
			@endif
                       </div>
		</div>	
                @endforeach
		</div> <!-- Cierre de la fila actual -->
            @endforeach

            <div class="text-end">
    		<button type="button" id="save-draft" class="btn btn-secondary">Guardar Borrador</button>
    		<button type="submit" class="btn btn-primary" id="submit-button">Enviar</button>
	    </div>
	
        </form>
        </div>
    </div>
     <script>
    // Lógica para abrir y cerrar la barra lateral
        document.getElementById('nav-toggle').addEventListener('click', function() {
            var sidebar = document.getElementById('sidebar');
            sidebar.classList.toggle('open');
        });

        // Lógica para expandir y contraer las subsecciones
        document.querySelectorAll('.expand-btn').forEach(function(btn) {
            btn.addEventListener('click', function() {
                var subsection = this.nextElementSibling;
                if (subsection.style.display === "none") {
                    subsection.style.display = "block";
                } else {
                    subsection.style.display = "none";
                }
            });
        });
	// Lógica para el botón de cierre de la barra lateral
	document.getElementById('closeButton').addEventListener('click', function() {
	    var sidebar = document.getElementById('sidebar');
	    sidebar.classList.remove('open');
	});
    function toggleOtherField(rowId) {
        const otherField = document.getElementById('other_field_' + rowId);
        otherField.style.display = otherField.style.display === 'none' ? 'block' : 'none';
    }
	const conditions = @json($conditions);
	console.log(conditions);

	document.addEventListener('DOMContentLoaded', function () {
      
        function updateQuestionVisibility() {
            conditions.forEach(condition => {
            const dependentQuestion = document.getElementById(`question-${condition.dependentQuestionId}`);
            const targetQuestion = document.getElementById(`question-${condition.questionId}`);

            if (!dependentQuestion || !targetQuestion) {
                return;
            }

            let selectedOption = null;

            // Obtener el valor seleccionado dependiendo del tipo de pregunta (radio, checkbox, select)
            if (dependentQuestion.querySelector('input[type="radio"]:checked')) {
                selectedOption = dependentQuestion.querySelector('input[type="radio"]:checked').value;
            } else if (dependentQuestion.querySelector('select')) {
                selectedOption = dependentQuestion.querySelector('select').value;
            }

            // Verificar si la condición se cumple y mostrar/ocultar la pregunta
            if (condition.optionType === 'equals' && selectedOption == condition.optionValue) {
                targetQuestion.style.display = 'block';
            } else {
                targetQuestion.style.display = 'none';
            }
        });        // Llama a la función al cargar la página
	// Añadir un evento para actualizar la visibilidad cada vez que se cambie una opción en las preguntas dependientes
    	}
	document.querySelectorAll('input[type="radio"], select').forEach(input => {
        input.addEventListener('change', updateQuestionVisibility);
    });
        updateQuestionVisibility();
    });
 	// Required fields code
        document.addEventListener('DOMContentLoaded', function () {
            const submitButton = document.querySelector('button[type="submit"]');
            const requiredFields = document.querySelectorAll('[required]');

            function validateForm() {
                let allFilled = true;
                requiredFields.forEach(field => {
                    if (!field.value) {
                        allFilled = false;
                        field.classList.add('is-invalid');
                    } else {
                        field.classList.remove('is-invalid');
                    }
                });
                submitButton.disabled = !allFilled;
            }

            requiredFields.forEach(field => {
                field.addEventListener('input', validateForm);
            });

            validateForm(); // Ejecutar la validación al cargar la página
        });
    </script>

@endsection
