<!-- resources/views/questionnaire/form.blade.php -->

@extends('layouts.main')

@section('content')
<div class="container">
    <h1>Cuestionario</h1>
    <form action="{{ route('questionnaire.submit') }}" method="POST">
        @csrf
        @foreach($questions as $question)
            <div class="mb-3">
                <label>{{ $question->text }}</label>
                <div>
                    @foreach($question->answers as $answer)
                        <div>
                            <input type="radio" name="question_{{ $question->id }}" value="{{ $answer->id }}">
                            <label>{{ $answer->text }}</label>
                        </div>
                    @endforeach
                </div>
            </div>
        @endforeach
        <button type="submit" class="btn btn-primary">Enviar</button>
    </form>
</div>
@endsection
