
@extends('layouts.main')
@section('content')
<link rel="stylesheet" href="{{ asset('css/survey.css') }}">

<div class="container">
    <div class="form-container sections">
    <form class="row g-3" id="household-visit-form">
        @csrf
	<!-- Campo oculto para enviar el form_id -->
    	<input type="hidden" name="form_id" value="{{ $form_id }}">
        <div class="row sub survey-section">
            <h3 class="subtitle">DATOS DEL HOGAR A VISITAR</h3>
        </div>

        <!-- Correlativo del Segmento Cartográfico -->
        <div class="col-md-6">
            <label for="p1" class="form-label">Correlativo del Segmento Cartográfico</label>
            <select id="p1" name="p1" class="form-select select2" required>
                <option value="">Seleccione un segmento...</option>
                @foreach($segmentUser as $segment)
                    <option value="{{ $segment->correlativo_segmento }}">{{ $segment->correlativo_segmento }}</option>
                @endforeach
            </select>
        </div>

        <!-- Región de Salud -->
        <div class="col-md-6">
            <label for="p2" class="form-label">Región de Salud</label>
            <input type="text" id="p2" class="form-control" name="p2" readonly>
        </div>

        <!-- Departamento -->
        <div class="col-md-6">
            <label for="p3" class="form-label">Departamento</label>
            <input type="text" id="p3" class="form-control" name="p3" readonly>
        </div>

        <!-- Municipio -->
        <div class="col-md-6">
            <label for="p4" class="form-label">Municipio</label>
            <input type="text" id="p4" class="form-control" name="p4" readonly>
        </div>

        <!-- Distrito -->
        <div class="col-md-6">
            <label for="p5" class="form-label">Distrito</label>
            <input type="text" id="p5" class="form-control" name="p5" readonly>
        </div>

        <!-- Área -->
        <div class="col-md-6">
            <label for="p6" class="form-label">Área</label>
            <input type="text" id="p6" class="form-control" name="p6" readonly>
        </div>
	<!-- Nombre de Supervisor de Gestión Local -->
	<div class="col-md-12">
	    <label for="p7" class="form-label">Nombre de Supervisor de Gestión Local</label>
	    <input type="text" id="p7" class="form-control" name="p7" value="{{ $user->name }}" readonly>
	</div>
	<!-- Fecha de Visita y Levantamiento de Datos -->
	<div class="col-md-12">
	    <label for="p8" class="form-label">Fecha de visita y levantamiento de datos</label>
	    <input type="text" id="p8" class="form-control" name="p8" value="{{ $currentDate }}" readonly>
	</div>
	<!-- Hora de Inicio -->
	<div class="col-md-6">
	    <label for="p9" class="form-label">Hora de Inicio</label>
	    <input type="text" id="p9" class="form-control" name="p9" value="{{ $currentTime }}" readonly>
	</div>
	<!-- Hora de Finalización -->
        <div class="col-md-6">
            <label for="p10" class="form-label">Hora de Finalización</label>
            <input type="text" id="p10" class="form-control" name="p10" readonly>
        </div>
	<!-- Sección de Coordinación Local -->
	 <div class="row sub survey-section">
            <h3 class="subtitle">COORDINACION LOCAL</h3>
        </div>

        <!-- Tabla de Registros Agregados con DataTables -->
	<div class="col-12 mb-3">
	    <table id="coordinationTable" class="table table-striped table-bordered" style="width:100%">
	        <thead>
	            <tr>
	                <th>Institución</th>
	                <th>Nombre de Establecimiento</th>
	                <th>Nombre de Jefatura</th>
	                <th>Teléfono Fijo</th>
	                <th>Teléfono Móvil</th>
	                <th>Correo Electrónico</th>
	                <th>Acciones</th>
	            </tr>
	        </thead>
	        <tbody id="coordination-rows">
	            <!-- Las filas se agregarán aquí dinámicamente -->
	        </tbody>
	    </table>
	</div>
	<!-- Botón para agregar más coordinaciones -->
	<div class="col-12 mb-3">
	   <button type="button" id="add-coordination-btn" class="btn btn-success" disabled>Agregar Coordinación</button>
	</div>
        <!-- Botón de enviar -->
	<table id="supportStaffTable" class="table table-bordered table-hover">
	    <thead>
	        <tr>
	            <th>Número</th>
	            <th>Nombre completo</th>
	            <th>Institución</th>
	            <th>Cargo</th>
	            <th>Teléfono fijo</th>
	            <th>Teléfono móvil</th>
	            <th>Correo electrónico</th>
	            <th>Acciones</th>
	        </tr>
	    </thead>
	    <tbody>
	        <!-- Las filas se generarán dinámicamente -->
	    </tbody>
	</table>
	<button type="button" id="add-support-btn" class="btn btn-success">Agregar Personal</button>

        <div class="col-12">
            <button type="submit" class="btn btn-primary">Guardar</button>
        </div>

    </form>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
     // Manejar la eliminación de filas
    $('#coordinationTable tbody').on('click', '.remove-row', function() {
        if (confirm("¿Estás seguro de que deseas eliminar esta fila?")) {
            var $row = $(this).closest('tr').prev('.parent'); 

    	// Remover la fila del DataTable
    	table.row($row).remove().draw(false); 
        }
    });
        // Inicializar DataTable con opciones de diseño compacto y scroll
    var table = $('#coordinationTable').DataTable({
        "paging": true,
        "searching": true,
        "ordering": true,
        "info": true,
        "autoWidth": true, // Permitir el ajuste automático de las columnas
    	"scrollCollapse": true,
    	"responsive": true, // Habilitar la capacidad responsiva
    	"scrollX": true, // Habilitar scroll horizontal si es necesario
        "columnDefs": [
            { "width": "20%", "targets": 0 },
            { "width": "20%", "targets": 1 },
            { "width": "20%", "targets": 2 },
            { "width": "10%", "targets": 3 },
            { "width": "10%", "targets": 4 },
            { "width": "10%", "targets": 5 },
            { "width": "10%", "targets": 6 }
        ]
    });
    var supportTable = $('#supportStaffTable').DataTable({
        "paging": true,
        "searching": true,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "responsive": true,
        "scrollX": true,
        "columnDefs": [
            { "width": "10%", "targets": 0 },
            { "width": "20%", "targets": 1 },
            { "width": "15%", "targets": 2 },
            { "width": "10%", "targets": 3 },
            { "width": "15%", "targets": 4 },
            { "width": "15%", "targets": 5 },
            { "width": "15%", "targets": 6 }
        ]
    });
    var supportCounter = 1; // Contador para el número de fila
    // Plantilla para una nueva fila
    function getNewRowTemplate(number) {
        return `
            <tr class="support-entry">
                <td><input type="text" name="p17[]" class="form-control" value="${number}" readonly></td>
                <td><input type="text" name="p18[]" class="form-control"></td>
                <td><input type="text" name="p19[]" class="form-control"></td>
                <td><input type="text" name="p20[]" class="form-control"></td>
                <td><input type="tel" name="p21[]" class="form-control"></td>
                <td><input type="tel" name="p22[]" class="form-control"></td>
                <td><input type="email" name="p23[]" class="form-control"></td>
                <td><button type="button" class="btn btn-danger remove-support-row">Eliminar</button></td>
            </tr>`;
    }

    // Plantilla para una nueva fila
    var newRowTemplate = `
        <tr class="coordination-entry">
            <td>
                <select class="form-select institution-select" name="p11[]">
                    <option value="">Seleccione...</option>
                    <option value="Minsal">Minsal</option>
                    <option value="Alcaldía">Alcaldía</option>
                    <option value="ADESCO">ADESCO</option>
                    <option value="ONG">ONG</option>
                    <option value="Otro">Otro</option>
                </select>
            </td>
            <td>
                <select class="form-select establishment-select" name="p12[]" style="display: none;">
                    <option value="">Seleccione un establecimiento...</option>
                </select>
            </td>
            <td><input type="text" name="p13[]" class="form-control"></td>
            <td><input type="tel" name="p14[]" class="form-control"></td>
            <td><input type="tel" name="p15[]" class="form-control"></td>
            <td><input type="email" name="p16[]" class="form-control"></td>
            <td>
                <button type="button" class="btn btn-danger remove-row">Eliminar</button>
            </td>
        </tr>`;

    // Manejar el evento de agregar nueva coordinación
    $('#add-coordination-btn').on('click', function() {
        // Crear un objeto jQuery a partir de la plantilla
        var $newRow = $(newRowTemplate);

        // Agregar la nueva fila al DataTable
        table.row.add($newRow[0]).draw(false);
    });
    // Manejar el evento de agregar nuevo personal
    $('#add-support-btn').on('click', function() {
         var $newRow = $(getNewRowTemplate(supportCounter));  // Asignar el número correspondiente
        supportTable.row.add($newRow[0]).draw(false);
        supportCounter++;  // Incrementar el contador
    });

    // Manejar la eliminación de filas
     $('#supportStaffTable tbody').on('click', '.remove-support-row', function() {
        // Obtener la fila principal que tiene la clase 'parent' (aunque el botón esté en la fila hija)
        var $row = $(this).closest('tr');

        if ($row.hasClass('child')) {
            // Si la fila es una fila hija, obtener la fila padre que tiene la clase 'parent'
            $row = $row.prev('.parent');
        }

        // Remover la fila del DataTable
        supportTable.row($row).remove().draw(false);  // Redibujar sin recargar toda la tabla

        // Recalcular los números de las filas restantes
        recalculateNumbers();
    });
    function recalculateNumbers() {
        supportCounter = 1;  // Reiniciar el contador
        $('#supportStaffTable tbody tr').each(function() {
            $(this).find('input[name="p17[]"]').val(supportCounter);
            supportCounter++;
        });
    }

    // Cargar establecimientos cuando se selecciona Minsal y se cambia el municipio o distrito
    $(document).on('change', '#p4, #p5, .p11', function() {
	var $currentRow = $(this).closest('.coordination-entry'); // Contexto de la fila actual
        var muni = $('#p4').val(); // Obtén el valor del municipio seleccionado
        var distrito = $('#p5').val(); // Obtén el valor del distrito seleccionado
        var ins = $currentRow.find('.p11').val(); 
	console.log('Valores: ', { muni: muni, distrito: distrito, ins: ins }); 
        // Verifica si la institución seleccionada es Minsal y si hay valores en muni y distrito
        if (ins === 'Minsal' && muni && distrito) {
            // Selecciona el select de establecimientos que está en la misma fila (coordinación local)
	    console.log('Condición Minsal cumplida'); 
            var establecimiento = $(this).closest('.coordination-entry').find('.p12');

            // Realiza la llamada AJAX para obtener los establecimientos
            $.ajax({
                url: '{{ route("household.visit.getEstablishments") }}',
                type: 'GET',
                data: {
                    muni: muni,         // Envía el valor de municipio
                    distrito: distrito  // Envía el valor de distrito
                },
                 success: function(data) {
		    console.log('Datos recibidos:', data);
                    // Asegúrate de limpiar el select y agregar una opción por defecto
                    establecimiento.empty().append('<option value="">Seleccione un establecimiento...</option>');

                    // Itera sobre los establecimientos recibidos y agrégalos al select
                    $.each(data, function(index, establishment) {
                        establecimiento.append('<option value="'+establishment.id+'">'+establishment.nombre+'</option>');
                    });

                    // Mostrar el select y remover cualquier estilo de ocultamiento
                    establecimiento.css('display', 'block');
                },
                error: function(xhr, status, error) {
                    console.error("Error al obtener los establecimientos: ", error);
                }
            });
        } else {
            // Si la institución no es Minsal, oculta el select de establecimiento
            $currentRow.find('.p12').hide();
        }
    });
    $('#p1').change(function() {
        var segmentValue = $(this).val(); // Obtiene el valor seleccionado
        var addCoordinationBtn = $('#add-coordination-btn');
	var addSupportBtn  = $('#add-support-btn');
        // Si se selecciona un segmento, habilita el botón; de lo contrario, deshabilítalo
        if (segmentValue) {
            addCoordinationBtn.prop('disabled', false); // Habilita el botón
	    addSupportBtn.prop('disabled', false); // Habilita el botón
        } else {
            addCoordinationBtn.prop('disabled', true); // Deshabilita el botón
	    addSupportBtn.prop('disabled', true); // Habilita el botón
        }
    });
	// Evento para obtener detalles del segmento seleccionado
        $('#p1').change(function() {
            var segmentId = $(this).val();
            if (segmentId) {
                $.ajax({
                    url: '/household-visit/segment-details/' + segmentId,
                    type: 'GET',
                    success: function(data) {
                        if (data) {
                            $('#p2').val(data.region);
                            $('#p3').val(data.department);
                            $('#p4').val(data.muni);
                            $('#p5').val(data.distrito);
                            $('#p6').val(data.area);
                        }
                    }
                });
            } else {
                // Limpiar los inputs si no hay un segmento seleccionado
                $('#p2').val('');
                $('#p3').val('');
                $('#p4').val('');
                $('#p5').val('');
                $('#p6').val('');
            }
        });
    // Manejar el envío del formulario
    $('#household-visit-form').on('submit', function(e) {
        e.preventDefault(); // Evita el envío normal del formulario

        // Empaquetar las respuestas del encabezado
        var headerData = {
            p1: $('#p1').val(),
            p2: $('#p2').val(),
            p3: $('#p3').val(),
            p4: $('#p4').val(),
            p5: $('#p5').val(),
            p6: $('#p6').val(),
            p7: $('#p7').val(),
            p8: $('#p8').val(),
            p9: $('#p9').val(),
            p10: $('#p10').val()
        };

        // Empaquetar las respuestas del DataTable (coordinaciones locales)
        var tableData = [];
        $('#coordinationTable tbody tr').each(function() {
            var row = {
                p11: $(this).find('select[name="p11[]"]').val(),
                p12: $(this).find('select[name="p12[]"]').val(),
                p13: $(this).find('input[name="p13[]"]').val(),
                p14: $(this).find('input[name="p14[]"]').val(),
                p15: $(this).find('input[name="p15[]"]').val(),
                p16: $(this).find('input[name="p16[]"]').val()
            };
            tableData.push(row);
        });
	var supportTableData = [];
	$('#supportStaffTable tbody tr').each(function() {
	    var row = {
	        p17: $(this).find('input[name="p17[]"]').val(),
	        p18: $(this).find('input[name="p18[]"]').val(),
	        p19: $(this).find('input[name="p19[]"]').val(),
	        p20: $(this).find('input[name="p20[]"]').val(),
	        p21: $(this).find('input[name="p21[]"]').val(),
	        p22: $(this).find('input[name="p22[]"]').val(),
	        p23: $(this).find('input[name="p23[]"]').val()
	    };
	    supportTableData.push(row);
	});
        // Empaquetar toda la información en un solo objeto
        var formData = {
            _token: $('input[name="_token"]').val(),  // Token CSRF
	    form_id: $('input[name="form_id"]').val(),
            section1: headerData,
            section2: tableData,
	    section3: supportTableData // Personal designado para apoyar
        };

        // Enviar los datos mediante AJAX
        $.ajax({
            url: '{{ route("survey.store") }}', // Ruta del controlador que procesará el formulario
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                // Manejar la respuesta del servidor
                alert('Formulario enviado exitosamente');
                window.location.href = '{{ route("form.success") }}'; // Redirigir al éxito
            },
            error: function(xhr, status, error) {
                // Manejar errores
                console.error('Error en el envío del formulario:', error);
                alert('Error al enviar el formulario');
            }
        });
    });
});
</script>
@endpush
