@extends('layouts.main')

@section('content')
<div class="container">
    <h1>Agregar Condición</h1>
<form action="{{ route('conditions.store') }}" method="POST">
    @csrf

    <div class="form-group">
        <label for="condition_type">Tipo de Condición</label>
        <select id="condition_type" name="condition_type" class="form-control">
            <option value="option">Condición por Opción</option>
            <option value="validation">Condición por Validación</option>
        </select>
    </div>

    <div id="option_condition" style="display: none;">
        <div class="form-group">
            <label for="question_id1">Pregunta</label>
            <select id="question_id1" name="question_id1" class="form-control">
                @foreach($questions as $question)
                    <option value="{{ $question->id }}">{{ $question->question_code }} {{ $question->question_text }}</option>
                @endforeach
            </select>
        </div>

        <div class="form-group">
            <label for="dependent_question_id">Pregunta Dependiente</label>
            <select id="dependent_question_id" name="dependent_question_id" class="form-control">
                @foreach($questions as $question)
                    <option value="{{ $question->id }}">{{ $question->question_code }} {{ $question->question_text }}</option>
                @endforeach
            </select>
        </div>
	<div class="form-group">
    	   <label for="option_type">Tipo de Expresion</label>
    	   <select id="option_type" name="option_type" class="form-control">
        	<option value="equals">Igual</option>
        	<option value="not_equals">No igual</option>
        	<option value="was_answered">Fue respondida</option>
            	<option value="not_answered">No fue respondida</option>
       	    </select>
	</div>

        <div class="form-group">
            <label for="option_value">Valor de la Opción</label>
            <input type="text" id="option_value" name="option_value" class="form-control">
        </div>
    </div>

    <div id="validation_condition" style="display: none;">
        <div class="form-group">
            <label for="question_id2">Pregunta</label>
            <select id="question_id2" name="question_id2" class="form-control">
                @foreach($questions as $question)
                    <option value="{{ $question->id }}">{{ $question->question_text }}</option>
                @endforeach
            </select>
        </div>

        <div class="form-group">
            <label for="validation_type">Tipo de Validación</label>
            <select id="validation_type" name="validation_type" class="form-control">
                <option value="equals">Igual</option>
                <option value="not_equals">No igual</option>
                <option value="greater_than">Mayor que</option>
                <option value="less_than">Menor que</option>
                <option value="greater_than_or_equals">Mayor o igual que</option>
                <option value="less_than_or_equals">Menor o igual que</option>
            </select>
        </div>

        <div class="form-group">
            <label for="validation_value">Valor de Validación</label>
            <input type="text" id="validation_value" name="validation_value" class="form-control">
        </div>
    </div>

    <button type="submit" class="btn btn-primary">Guardar Condición</button>
</form>

<script>
    document.getElementById('condition_type').addEventListener('change', function () {
        let conditionType = this.value;
        document.getElementById('option_condition').style.display = conditionType === 'option' ? 'block' : 'none';
        document.getElementById('validation_condition').style.display = conditionType === 'validation' ? 'block' : 'none';
    });
    document.getElementById('option_type').addEventListener('change', function () {
        let optionType = this.value;
        let optionValueLabel = document.querySelector('label[for="option_value"]');
        if (optionType === 'was_answered' || optionType === 'not_answered') {
	    optionValueLabel.style.display = 'none';
            document.getElementById('option_value').style.display = 'none';
        } else {
	    optionValueLabel.style.display = 'block';
            document.getElementById('option_value').style.display = 'block';
        }
    });
</script>
@endsection
