<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>KML Map</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <style>
        #map {
            height: 500px;
            width: 100%;
        }
    </style>
    <link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css" />
    <script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>
</head>
<body>
    <form id="kmlForm" action="{{ route('kml.process') }}" method="POST" enctype="multipart/form-data">
        @csrf
        <input type="file" id="kmlFile" name="kml_file" accept=".kml">
        <button type="submit">Cargar KML</button>
    </form>
    <div id="map"></div>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Inicializar el mapa
            var map = L.map('map').setView([51.505, -0.09], 13);

            // Añadir capa base al mapa
            L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                maxZoom: 19
            }).addTo(map);

            // Manejar la carga del archivo KML
            document.getElementById('kmlForm').addEventListener('submit', function(e) {
                e.preventDefault();
                var formData = new FormData(this);

                fetch('{{ route('kml.process') }}', {
                    method: 'POST',
                    body: formData,
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    }
                })
                .then(response => {
                    if (!response.ok) {
                        throw new Error('Network response was not ok ' + response.statusText);
                    }
                    return response.json();
                })
                .then(data => {
                    if (data.geometries) {
                        data.geometries.forEach(function(geometry) {
                            // Aquí puedes agregar la geometría al mapa
                            L.geoJSON(geometry).addTo(map);
                        });
                    } else {
                        alert('Error al procesar el archivo KML');
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                });
            });
        });
    </script>
</body>
</html>

