@extends('layouts.main')

@section('content')
<div class="container">
    <h1>Reasignar Segmento a Nuevo Equipo</h1>

    <form action="{{ route('household_teams.storeReassign', $householdTeam->id) }}" method="POST">
        @csrf
        @method('PUT')

         <div class="form-group mb-3">
            <label for="correlativo_segmento">Segmento</label>
            <input type="text" class="form-control" id="correlativo_segmento" name="correlativo_segmento" value="{{ $householdTeam->segment->correlativo_segmento }}" readonly>
        </div>

        <div class="form-group mb-3">
            <label for="current_team">Equipo Actual</label>
            <input type="text" class="form-control" id="current_team" name="current_team" value="{{ $currentTeam->name }}" readonly>
        </div>

        <div class="form-group mb-3">
            <label for="team_id">Nuevo Equipo</label>
            <select class="form-control" id="team_id" name="team_id" required>
                @foreach($teams as $team)
                    <option value="{{ $team->id }}" {{ $householdTeam->team_id == $team->id ? 'selected' : '' }}>
                        {{ $team->name }}
                    </option>
                @endforeach
            </select>
            @error('team_id')
                <div class="alert alert-danger">{{ $message }}</div>
            @enderror
        </div>


        <button type="submit" class="btn btn-warning">Reasignar</button>
    </form>
</div>
@endsection
