@extends('layouts.main')

@section('content')
<div class="container">
    <h1>Lista de Miembros del Hogar</h1>

    @if (session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    <a href="{{ route('household_members.create') }}" class="btn btn-primary mb-3">Agregar Miembro del Hogar</a>
    <a href="{{ route('household_members.create') }}" class="btn btn-primary mb-3">Agregar Miembro del Hogar</a>

    <form method="GET" action="{{ route('household_members.index') }}" class="mb-3">
        <div class="form-group">
            <label for="correlativo_segmento">Filtrar por Correlativo de Segmento:</label>
            <input type="text" name="correlativo_segmento" id="correlativo_segmento" class="form-control" placeholder="Ingrese Correlativo de Segmento" value="{{ request('correlativo_segmento') }}">
        </div>
        <button type="submit" class="btn btn-primary">Filtrar</button>
    </form>

    

    @foreach ($members->groupBy('household_id') as $householdId => $householdMembers)
        <h2>Household ID: {{ $householdId }}</h2>
        <table class="table table-bordered table-sm">
            <thead class="thead-dark">
                <tr>
                    <th>ID</th>
                    <th>Número de Línea</th>
                    <th>Nombre</th>
                    <th>Apellido</th>
                    <th>Fecha de Nacimiento</th>
                    <th>Edad (Días)</th>
                    <th>Edad (Meses)</th>
                    <th>Edad (Años)</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($householdMembers as $member)
                    <tr>
                        <td>{{ $member->id }}</td>
                        <td>{{ $member->numero_de_linea }}</td>
                        <td>{{ $member->nombre }}</td>
                        <td>{{ $member->apellido }}</td>
                        <td>{{ \Carbon\Carbon::parse($member->fecha_nacimiento)->format('m-Y') }}</td>
                        <td>{{ $member->edad_dia }}</td>
                        <td>{{ $member->edad_mes }}</td>
                        <td>{{ $member->edad_anio }}</td>
                        <td>
                            <a href="{{ route('household_members.edit', $member->id) }}" class="btn btn-warning btn-sm">
                                <i class='bx bx-edit'></i>
                            </a>
                            <form action="{{ route('household_members.destroy', $member->id) }}" method="POST" style="display: inline-block;">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger btn-sm">
                                    <i class='bx bx-trash'></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endforeach
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
        $('.select2').select2();
        
        $('#household_id').on('change', function() {
            var householdId = $(this).val();
            $.ajax({
                url: '/get-orders/' + householdId,
                method: 'GET',
                success: function(data) {
                    $('#orden_vivienda').empty().append('<option value="">Todos</option>');
                    $.each(data.orders, function(index, order) {
                        $('#orden_vivienda').append('<option value="' + order + '">' + order + '</option>');
                    });
                    $('#orden_vivienda').select2();
                }
            });

            $.ajax({
                url: '/get-numbers/' + householdId,
                method: 'GET',
                success: function(data) {
                    $('#numero_vivienda').empty().append('<option value="">Todos</option>');
                    $.each(data.numbers, function(index, number) {
                        $('#numero_vivienda').append('<option value="' + number + '">' + number + '</option>');
                    });
                    $('#numero_vivienda').select2();
                }
            });
        });
    });
</script>
@endpush
