<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Screen Lock</title>
    <link href="{{ asset('css/app.css') }}" rel="stylesheet">
    <script src="{{ asset('js/app.js') }}" defer></script>
    <style>
        .lock-screen-container {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            height: 100vh;
            background-color: #f5f5f5;
        }
        .lock-screen-container h2 {
            margin-bottom: 20px;
        }
        .lock-screen-container .form-group {
            margin-bottom: 15px;
        }
        .lock-screen-container button {
            padding: 10px 20px;
        }
    </style>
</head>
<body>
    <div class="lock-screen-container">
        <h2>Screen Locked</h2>
        <form id="unlock-form" method="POST" action="{{ route('unlock') }}">
            @csrf
            <div class="form-group">
                <label for="password">Enter your password to unlock:</label>
                <input type="password" id="password" name="password" required>
            </div>
            <button type="submit">Unlock</button>
        </form>
	 @if ($errors->any())
        <div>
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    </div>
</body>
<script>
        document.getElementById('unlock-form').addEventListener('submit', function() {
            localStorage.removeItem('isLocked');
            history.pushState(null, null, location.href);
        });

        window.onpopstate = function() {
            if (localStorage.getItem('isLocked') === 'true') {
                window.location.href = '{{ route('screen.lock') }}';
            }
        };
    </script>
</html>
