import { datosPorRegion } from './ubicaciones.js';

document.addEventListener('DOMContentLoaded', function() {
    const regionSelect = document.getElementById('region');
    const departmentSelect = document.getElementById('depa');
    const municipalitySelect = document.getElementById('muni');
    const districtSelect = document.getElementById('distrito');
    const cantonSelect = document.getElementById('canton');
    const segmentSelect = document.getElementById('segmento');

    function populateSelect(selectElement, options, selectedValue = '') {
        selectElement.innerHTML = '<option value="">Seleccione una opción</option>';
        options.forEach(option => {
            if (option.value !== undefined) {
                const optionElement = document.createElement('option');
                optionElement.value = option.value;
                optionElement.textContent = option.label;
                selectElement.appendChild(optionElement);
            }
        });
        if (selectedValue) {
            selectElement.value = selectedValue;
            const defaultOption = selectElement.querySelector('option[value=""]');
            if (defaultOption) {
                defaultOption.remove(); // Elimina la opción por defecto
            }
        }
        selectElement.disabled = options.length === 0;
    }

    function handleRegionChange() {
        const selectedRegion = regionSelect.value;
        const depa = datosPorRegion[selectedRegion] ? Object.keys(datosPorRegion[selectedRegion]).map(depa => ({ value: depa, label: depa })) : [];
        populateSelect(departmentSelect, depa);
        populateSelect(municipalitySelect, []);
        populateSelect(districtSelect, []);
        populateSelect(cantonSelect, []);
        populateSelect(segmentSelect, []);
    }

    function handleDepartmentChange() {
        const selectedDepartment = departmentSelect.value;
        const muni = datosPorRegion[regionSelect.value]?.[selectedDepartment] ? Object.keys(datosPorRegion[regionSelect.value][selectedDepartment]).map(muni => ({ value: muni, label: muni })) : [];
        populateSelect(municipalitySelect, muni);
        populateSelect(districtSelect, []);
        populateSelect(cantonSelect, []);
        populateSelect(segmentSelect, []);
    }

    function handleMunicipalityChange() {
        const selectedMunicipality = municipalitySelect.value;
        const distritos = datosPorRegion[regionSelect.value]?.[departmentSelect.value]?.[selectedMunicipality] ? Object.keys(datosPorRegion[regionSelect.value][departmentSelect.value][selectedMunicipality]).map(distrito => ({ value: distrito, label: distrito })) : [];
        populateSelect(districtSelect, distritos);
        populateSelect(cantonSelect, []);
        populateSelect(segmentSelect, []);
    }

    function handleDistrictChange() {
        const selectedDistrict = districtSelect.value;
        const cantones = datosPorRegion[regionSelect.value]?.[departmentSelect.value]?.[municipalitySelect.value]?.[selectedDistrict] ? Object.keys(datosPorRegion[regionSelect.value][departmentSelect.value][municipalitySelect.value][selectedDistrict]).map(canton => ({ value: canton, label: canton })) : [];
        populateSelect(cantonSelect, cantones);
        populateSelect(segmentSelect, []);
    }

    function handleCantonChange() {
        const selectedCanton = cantonSelect.value;
        const segmentos = datosPorRegion[regionSelect.value]?.[departmentSelect.value]?.[municipalitySelect.value]?.[districtSelect.value]?.[selectedCanton] ? datosPorRegion[regionSelect.value][departmentSelect.value][municipalitySelect.value][districtSelect.value][selectedCanton].map(segmento => ({ value: segmento, label: segmento })) : [];
        populateSelect(segmentSelect, segmentos);
    }

    function handleSegmentChange() {
        const selectedSegment = segmentSelect.value;

        let found = false;
        for (const region in datosPorRegion) {
            for (const depa in datosPorRegion[region]) {
                for (const muni in datosPorRegion[region][depa]) {
                    for (const distrito in datosPorRegion[region][depa][muni]) {
                        for (const canton in datosPorRegion[region][depa][muni][distrito]) {
                            if (datosPorRegion[region][depa][muni][distrito][canton].includes(selectedSegment)) {
                                populateSelect(regionSelect, [{ value: region, label: region }], region);
                                handleRegionChange();

                                populateSelect(departmentSelect, [{ value: depa, label: depa }], depa);
                                handleDepartmentChange();

                                populateSelect(municipalitySelect, [{ value: muni, label: muni }], muni);
                                handleMunicipalityChange();

                                populateSelect(districtSelect, [{ value: distrito, label: distrito }], distrito);
                                handleDistrictChange();

                                populateSelect(cantonSelect, [{ value: canton, label: canton }], canton);
                                handleCantonChange();

                                found = true;
                                break;
                            }
                        }
                        if (found) break;
                    }
                    if (found) break;
                }
                if (found) break;
            }
            if (found) break;
        }
    }

    regionSelect.addEventListener('change', handleRegionChange);
    departmentSelect.addEventListener('change', handleDepartmentChange);
    municipalitySelect.addEventListener('change', handleMunicipalityChange);
    districtSelect.addEventListener('change', handleDistrictChange);
    cantonSelect.addEventListener('change', handleCantonChange);
    segmentSelect.addEventListener('change', handleSegmentChange);

    // Inicializa los segmentos si ya hay datos cargados
    const segmentOptions = [];

    for (const region in datosPorRegion) {
        for (const depa in datosPorRegion[region]) {
            for (const muni in datosPorRegion[region][depa]) {
                for (const distrito in datosPorRegion[region][depa][muni]) {
                    for (const canton in datosPorRegion[region][depa][muni][distrito]) {
                        const segmentos = datosPorRegion[region][depa][muni][distrito][canton];
                        if (Array.isArray(segmentos)) {
                            segmentOptions.push(...segmentos.map(segmento => ({ value: segmento, label: segmento })));
                        }
                    }
                }
            }
        }
    }

    populateSelect(segmentSelect, segmentOptions);
});
