import { datosPorRegion } from './ubicaciones.js';

const regionSelect = document.getElementById('region');
const departmentSelect = document.getElementById('depa');
const municipalitySelect = document.getElementById('muni');
const districtSelect = document.getElementById('distrito');
const cantonSelect = document.getElementById('canton');
const segmentSelect = document.getElementById('segmento');

function populateSelect(selectElement, options, selectedValue = '') {
    selectElement.innerHTML = '<option value="">Seleccione una opción</option>';
    options.forEach(option => {
        const optionElement = document.createElement('option');
        optionElement.value = option.value;
        optionElement.textContent = option.label;
        if (option.value === selectedValue) {
            optionElement.selected = true; // Agrega la propiedad selected
        }
        selectElement.appendChild(optionElement);
    });
    selectElement.disabled = options.length === 0;
}

function getSegmentOptions() {
    const segmentOptions = [];
    for (const region in datosPorRegion) {
        for (const depa in datosPorRegion[region]) {
            for (const muni in datosPorRegion[region][depa]) {
                for (const distrito in datosPorRegion[region][depa][muni]) {
                    for (const canton in datosPorRegion[region][depa][muni][distrito]) {
                        const segmentos = datosPorRegion[region][depa][muni][distrito][canton];
                        if (Array.isArray(segmentos)) {
                            segmentOptions.push(...segmentos.map(segmento => ({ value: segmento, label: segmento })));
                        }
                    }
                }
            }
        }
    }
    return segmentOptions;
}

function handleSegmentChange() {
    const selectedSegment = $(segmentSelect).val();  // Utilizar jQuery para obtener el valor
    let found = false;

    for (const region in datosPorRegion) {
        for (const depa in datosPorRegion[region]) {
            for (const muni in datosPorRegion[region][depa]) {
                for (const distrito in datosPorRegion[region][depa][muni]) {
                    for (const canton in datosPorRegion[region][depa][muni][distrito]) {
                        const segmentos = datosPorRegion[region][depa][muni][distrito][canton];
                        if (segmentos.includes(selectedSegment)) {
                            populateSelect(regionSelect, [{ value: region, label: region }], region);
                            populateSelect(departmentSelect, [{ value: depa, label: depa }], depa);
                            populateSelect(municipalitySelect, [{ value: muni, label: muni }], muni);
                            populateSelect(districtSelect, [{ value: distrito, label: distrito }], distrito);
                            populateSelect(cantonSelect, [{ value: canton, label: canton }], canton);
                            found = true;
                            break;
                        }
                    }
                    if (found) break;
                }
                if (found) break;
            }
            if (found) break;
        }
        if (found) break;
    }
}

// Inicializa los segmentos si ya hay datos cargados
const segmentOptions = getSegmentOptions();
populateSelect(segmentSelect, segmentOptions);

// Añadir evento para cambios en Select2
$('#segmento').on('change', handleSegmentChange);
