<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Team extends Model
{
    use HasFactory;

    protected $table = 'teams'; 

    protected $fillable = ['name'];

    public function users()
    {
        return $this->hasMany(User::class);
    }
     public function users2()
    {
        return $this->belongsToMany(User::class, 'team_user', 'team_id', 'user_id');
    }
    public function households()
    {
        return $this->hasMany(HouseholdTeam::class);
    }
}

