<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FormSection extends Model
{
    use HasFactory;

    protected $fillable = [
        'form_id',
        'section_name',
        'section_order',
        'description'
    ];

    public function form()
    {
        return $this->belongsTo(Form::class);
    }
    
    public function questions()
    {
        return $this->hasManyThrough(Question::class, SectionQuestion::class, 'section_id', 'id', 'id', 'question_id');
    }
}

