<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Form extends Model
{
    use HasFactory;

    protected $table = 'forms';

    protected $fillable = [
        'form_name',
        'description',
        'created_at',
        'updated_at'
    ];

     public function formSections()
    {
        return $this->hasMany(FormSection::class, 'form_id');
    }

    /**
     * Relación con las preguntas a través de las secciones.
     * Un formulario tiene muchas preguntas a través de sus secciones.
     */
    public function questions()
    {
        return $this->hasManyThrough(Question::class, Section::class, 'id', 'id', 'id', 'question_id')
                    ->join('sections_questions', 'sections.id', '=', 'sections_questions.section_id')
                    ->join('questions', 'sections_questions.question_id', '=', 'questions.id');
    }
}
	
