<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Establishment extends Model
{
    use HasFactory;

    // Nombre de la tabla en la base de datos
    protected $table = 'establecimiento';

    // Campos que pueden ser asignados de manera masiva
    protected $fillable = [
        'nombre',
        'codigo',
        'institucion_salud',
        'muni',
        'distrito',
    ];

    /**
     * Relación con la tabla de municipios.
     */
    public function muni()
    {
        return $this->belongsTo(Muni::class, 'muni', 'codigo');
    }

    /**
     * Relación con la tabla de distritos.
     */
    public function distrito()
    {
        return $this->belongsTo(Distrito::class, 'distrito', 'codigo');
    }
}

