<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Condition extends Model
{
    protected $fillable = [
        'question_id',
        'dependent_question_id',
        'condition_type',
        'condition_value',
    ];

    // Define las relaciones con el modelo Question
    public function question()
    {
        return $this->belongsTo(Question::class, 'question_id');
    }

    public function dependentQuestion()
    {
        return $this->belongsTo(Question::class, 'dependent_question_id');
    }
}
