<?php

// app/Imports/HouseholdMembersImport.php

namespace App\Imports;

use App\Models\HouseholdMember;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Illuminate\Support\Carbon;

class HouseholdMembersImport implements ToModel, WithHeadingRow
{
    public function model(array $row)
    {

        return new HouseholdMember([
            'household_id' => $row['household_id'],
            'numero_de_linea' => $row['numero_de_linea'],
            'nombre' => $row['nombre'],
            'edad' => $row['edad'],
            'sexo' => $row['sexo'],
            'grupo_edad' => $row['grupo_edad'],
            'seleccionado' => $row['seleccionado'],
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ]);
    }
     private function convertToDate($dateString)
    {
        return Carbon::createFromFormat('m-Y', $dateString)->startOfMonth()->format('Y-m-d');
    }
}
