<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use App\Models\Question;
use Illuminate\Http\Request;
use App\Models\Segment;
use App\Models\Region;
use App\Models\Departamento;
use App\Models\Muni;
use App\Models\Distrito;
use App\Models\Canton;
use App\Models\Form;
use App\Models\Section;
use App\Models\OptionCondition;
use App\Models\ValidationCondition;
use App\Models\SectionQuestion;
use App\Models\SegmentUser;
use App\Models\Establishment;
use Illuminate\Support\Str;
use Carbon\Carbon;
use App\Models\Answer;


class SurveyController extends Controller
{
    public function show($form_id)
    {
        $form = Form::with(['formSections.questions'])->findOrFail($form_id);
	$form->formSections = $form->formSections->sortBy('section_order');
	$questionIds = $form->formSections->flatMap(function ($section) {
    	    return $section->questions->pluck('id');
	});


    	$segments = Segment::where('active', 1)->get();
	// Obtener el ID del usuario coordinador logueado
	$user = Auth::user();
        $userId = auth()->user()->id;

        // Obtener los segmentos asignados a este usuario
        $segmentUser = SegmentUser::where('user_id', $userId)
			    ->where('coordinacion', 1)
                            ->with('segment')
                            ->get();
	 // Obtener los segmentos asignados a este usuario
        $segmentUser2 = SegmentUser::where('user_id', $userId)
                            ->with('segment')
                            ->get();
	// Obtener la fecha actual
    	$currentDate = now()->format('d/m/Y');
	// Obtener la hora actual en formato de 12 horas
    	$currentTime = Carbon::now()->format('h:i A');

	// Obtener todas las condiciones asociadas con el formulario
	$optionConditions = OptionCondition::whereIn('question_id', $questionIds)->get();
	// Convertir las condiciones en un array de formato usable por JavaScript
    	$conditions = $optionConditions->map(function($condition) {
            return [
            	'questionId' => $condition->question_id,
            	'dependentQuestionId' => $condition->dependent_question_id,
            	'optionType' => $condition->option_type, // 'equals' o 'not_equals'
            	'optionValue' => $condition->option_value // valor de la opción
            ];
    	});
	$validationConditions = ValidationCondition::whereIn('question_id', $form->formSections->pluck('questions.id'))
                                           ->get();
	$sectionIds = $form->formSections->pluck('id');
	$sectionQuestions = SectionQuestion::whereIn('question_id', $questionIds)
				   ->whereIn('section_id', $sectionIds)
                                   ->get();
	\Log::info($questionIds);
	\Log::info($optionConditions);
	\Log::info($sectionQuestions);
    	if ($form_id == 1 && $user->role->name == 'Coordinador/a') {
            return view('survey.form5', compact('segmentUser','user','currentDate','currentTime','form_id'));
    	} elseif ($form_id == 5 && $user->role->name == 'Administrador') {
            return view('survey.form0', compact('form', 'segmentUser', 'conditions', 'validationConditions', 'sectionQuestions','form_id','user','currentDate', 'currentTime'));
	} elseif ($form_id == 20) {
    	    return view('survey.form2', compact('form', 'segments', 'conditions', 'validationConditions', 'sectionQuestions'));
    	} elseif ($form_id == 2 && $user->role->name == 'Coordinador/a') {
            return view('survey.form8', compact('segmentUser2','user','currentDate','currentTime','form_id'));
        }  elseif ($form_id == 6) {
            return view('survey.form6', compact('form', 'segments', 'conditions', 'validationConditions', 'sectionQuestions'));
        } 
	  else {
    	    abort(404); // Si no hay formulario con ese ID, mostrar 404
    	}
    }
    public function cview($correlativoSegmento)
{
    // Obtener el ID del usuario autenticado
    $userId = auth()->id();

    // Buscar el registro en la tabla answers que coincida con el correlativo_segmento y el user_id
    $answer = DB::table('answers')
        ->whereRaw('JSON_EXTRACT(answers, "$.seccion1.p1") = ?', [$correlativoSegmento])
        ->where('user_id', '=', $userId)  // Validar el user_id
        ->first();  // Obtener solo un registro
    
    // Validar si se encontró el registro
    if ($answer) {
        // Decodificar el JSON para poder acceder a los datos específicos
        $answersData = json_decode($answer->answers, true);

        // Aquí puedes extraer los datos específicos del formulario, como seccion1, seccion2, etc.
        $seccion1 = $answersData['seccion1'];
        $seccion2 = $answersData['seccion2'] ?? [];
	$seccion3 = $answersData['seccion3'] ?? null;
        $seccion4 = $answersData['seccion4'] ?? null;
        $seccion5 = $answersData['seccion5'] ?? null;
        // ... y así con las demás secciones según lo necesites

        // Pasar los datos a la vista
        return view('coordinador.view', compact('seccion1', 'seccion2', 'seccion3', 'seccion4', 'seccion5', 'answer'));

    } else {
        // Si no se encuentra el registro, redirigir para completar el formulario 1
        return redirect()->route('survey.show', ['id' => 1])
            ->with('message', 'Debes completar el formulario 1 para continuar.');
    }
}
   
    public function getFilteredOptions(Request $request)
    {
    // Habilitar el registro de consultas
    DB::enableQueryLog();

    $segmentId = $request->input('segment_id');
    
    // Obtener el segmento por el correlativo_segmento
    $segment = Segment::where('id', $segmentId)->firstOrFail();

    // Obtener la región asociada al segmento
    $region = Region::where('codigo', $segment->region)->first();
    
    // Obtener el departamento asociado al segmento
    $dpto = Departamento::where('codigo', $segment->dpto)->first();
    
    // Obtener el municipio asociado al segmento
    $municipio = Muni::where('codigo', $segment->muni)->first();
    
    // Obtener el distrito asociado al segmento
    $distrito = Distrito::where('codigo', $segment->distrito)->first();
    
    // Obtener el cantón asociado al segmento
 
    // Aquí se obtienen las regiones, departamentos, municipios, distritos y cantones 
    // basados en los datos relacionados con el segmento.
    $regions = Region::whereIn('codigo', [$segment->region])->get();
    $departments = Departamento::whereIn('codigo', [$segment->dpto])->get();
    $municipios = Muni::whereIn('codigo', [$segment->muni])->get();
    $distritos = Distrito::whereIn('muni', [$segment->muni])->get();
    //$cantons = Canton::whereIn('codigo', [$segment->canton])->get();
    
    // Obtener todas las consultas ejecutadas
    $queries = DB::getQueryLog();

    // Imprimir todas las consultas
    foreach ($queries as $query) {
        // Mostrar la consulta con sus bindings
        \Log::info($query['query'], $query['bindings']);
    }
    // Retornar todos los datos asociados
    return response()->json([
        'regions' => $regions->map(fn($region) => ['id' => $region->codigo, 'name' => $region->nombre]),
        'departments' => $departments->map(fn($dpto) => ['id' => $dpto->codigo, 'name' => $dpto->nombre]),
        'municipios' => $municipios->map(fn($municipio) => ['id' => $municipio->codigo, 'name' => $municipio->nombre]),
        'distritos' => $distritos->map(fn($distrito) => ['id' => $distrito->codigo, 'name' => $distrito->nombre]),
	'queries' => $queries, // Incluir las consultas en la respuesta
    ]);
}
      public function getEstablishments(Request $request)
    {
        // Obtener los nombres del municipio y distrito enviados desde la vista
        $muniName = $request->input('p4');
        $distritoName = $request->input('p5');

        // Obtener los códigos de municipio y distrito a partir de los nombres
        $muni = Muni::where('nombre', $muniName)->first();
        $distrito = Distrito::where('nombre', $distritoName)->first();

        // Validar si se encontraron los códigos de municipio y distrito
        if ($muni && $distrito) {
            $muniCode = $muni->codigo;
            $distritoCode = $distrito->codigo;

            // Consultar los establecimientos que coinciden con los códigos de municipio y distrito
            $establishments = Establishment::where('muni', $muniCode)
                ->where('distrito', $distritoCode)
                ->where('institucion_salud', '01') // Filtrar solo los de Minsal (código 01)
                ->get();

            return response()->json($establishments);
        }

        // Si no se encuentran los códigos, retornar una respuesta vacía
        return response()->json([]);
    }
    public function store(Request $request)
    {
    // Recuperar el encabezado y las respuestas del DataTable
    $headerData = $request->input('section1');
    $tableData = $request->input('section2');
    $supportStaffData = $request->input('section3');
    $supportStaffData2 = $request->input('section4');
    $ResultData = $request->input('section5');

    // Generar un unique_code
    $uniqueCode = Str::random(16);

    // Recuperar el form_id desde el formulario
    $formId = $request->input('form_id');

    // Empaquetar y guardar las respuestas
    $packedAnswers = json_encode([
        'seccion1' => $headerData,
        'seccion2' => $tableData,
	'seccion3' => $supportStaffData,
	'seccion4' => $supportStaffData2,
	'seccion5' => $ResultData,
    ]);

    // Guardar en la tabla 'answers'
    Answer::create([
        'form_id' => $formId,
        'unique_code' => $uniqueCode,
        'answers' => $packedAnswers,
        'user_id' => auth()->user()->id
    ]);

    // Redireccionar o devolver respuesta
    return response()->json(['status' => 'success']);
    }
    public function success()
    {
    	// Puedes pasar un mensaje de éxito o simplemente renderizar una vista.
    	return view('survey.form_success');  // Asegúrate de tener la vista `form/success.blade.php`.
    }
}
