<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Segment;
use Illuminate\Support\Facades\DB;

class SegmentController extends Controller
{
    public function getActiveSegmentsCount()
    {
        $count = Segment::where('active', 1)->count();
        return response()->json(['count' => $count]);
    }
    public function getAssignedSegmentsCount()
    {
        $counts = DB::table('household_team')
            ->select('correlativo_segmento', DB::raw('count(*) as count'))
            ->groupBy('correlativo_segmento')
            ->get();

        return response()->json($counts);
    }
}
