<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Segment;
use App\Models\Region;
use App\Models\Department;
use App\Models\Municipality;
use App\Models\District;
use App\Models\Question;
use App\Models\MatrixQuestion;
use App\Models\Answer;

class QuestionController extends Controller
{
    // Mostrar todas las preguntas
    public function index()
    {
        $questions = Question::with('answers')->get();
        // Retornar la vista con las preguntas
        return view('survey.questions.index', compact('questions'));
    }
    public function create()
    {
     	return view('survey.create');
    }

    // Mostrar una pregunta específica por ID
    public function show($id)
    {
    	// Encuentra la pregunta junto con sus respuestas
    	$question = Question::with(['answers', 'condition', 'dependentQuestions'])->findOrFail($id);

    	// Devuelve los datos como un array JSON
   	 return response()->json($question);
    }

    // Crear una nueva pregunta
    public function store(Request $request){

    $request->validate([
        'question_text' => 'required|string',
        'question_type' => 'required|in:text,radio,checkbox,select,textarea,matrix,date,numeric,note,range,time',
        'is_required' => 'required|boolean',
        'question_code' => 'nullable|string|max:50',
        'style_class' => 'nullable|string|max:255',
        /*'matrix_rows' => 'required_if:question_type,matrix|array',
        'matrix_columns' => 'required_if:question_type,matrix|array',
        'has_other' => 'nullable|boolean',*/
    ]);

    // Crear la pregunta
    $question = Question::create([
        'question_text' => $request->input('question_text'),
        'question_type' => $request->input('question_type'),
        'is_required' => $request->input('is_required'),
        'question_code' => $request->input('question_code'),
	'style_class' => $request->input('style_class'),
    ]);

    // Crear matriz de preguntas y sus filas y columnas dentro de una transacción
    /*if ($question->question_type == 'matrix') {
        DB::transaction(function () use ($request, $question) {
            // Crear la pregunta de matriz
            $matrixQuestion = MatrixQuestion::create([
                'question_id' => $question->id,
                'has_other' => $request->input('has_other', false),
            ]);

            // Crear las filas de la matriz
            foreach ($request->input('matrix_rows') as $rowText) {
                MatrixRow::create([
                    'matrix_question_id' => $matrixQuestion->id,
                    'row_text' => $rowText,
                ]);
            }

            // Crear las columnas de la matriz
            foreach ($request->input('matrix_columns') as $columnText) {
                MatrixColumn::create([
                    'matrix_question_id' => $matrixQuestion->id,
                    'column_text' => $columnText,
                    'has_other' => $request->input('has_other') && $columnText === 'Otro' ? true : false,
                ]);
            }
        });
    }*/

    // Redirigir a la lista de preguntas
    return redirect()->route('questions.index')->with('success', 'Pregunta creada con éxito');
    }
    public function edit($id)
    {
    	$question = Question::findOrFail($id);
    	$conditions = $question->dependentQuestions;

    	return view('survey.questions.edit', compact('question', 'conditions'));
    }

    public function update(Request $request, $id)
    {
    // Validación de los campos de la pregunta
     $request->validate([
        'question_text' => 'required|string',
        'question_type' => 'required|in:text,radio,checkbox,select,textarea,matrix,date,numeric,note,range,time',
        //'is_required' => 'required|boolean',
        'question_code' => 'nullable|string|max:50',
        'question_enum' => 'nullable|string|max:50',
	'style_class' => 'nullable|string|max:255',
        //'condition_id' => 'nullable|integer|exists:conditions,id',
        /*'matrix_rows' => 'required_if:question_type,matrix|array',
        'matrix_columns' => 'required_if:question_type,matrix|array',
        'has_other' => 'nullable|boolean',*/
    ]);

    // Encuentra la pregunta por ID
    $question = Question::findOrFail($id);

    // Actualiza la pregunta
    /*$question->update([
        'question_text' => $request->input('question_text'),
        'question_type' => $request->input('question_type'),
        'is_required' => $request->input('is_required', false),
        'question_code' => $request->input('question_code'),
        'style_class' => $request->input('style_class'),
        'condition_id' => $request->input('condition_id'),
    ]);*/

        $question->question_text = $request->question_text;
	$question->question_type = $request->question_type;
        //$question->is_required = $request->is_required;
	$question->question_code = $request->question_code;
	$question->question_enum = $request->question_enum;
	$question->style_class = $request->style_class;
	//$question->condition_id = $request->condition_id;
        
        $question->save();
    // Manejo de las respuestas asociadas
    /*if ($request->has('answers')) {
        // Elimina respuestas antiguas y agrega nuevas
        $question->answers()->delete();
        foreach ($request->input('answers') as $answer) {
            $question->answers()->create([
                'answer_text' => $answer['answer_text'],
            ]);
        }
    }*/

    // Retorna la pregunta actualizada
    return redirect()->route('questions.index')
                     ->with('success', 'Pregunta actualizada exitosamente.');

    }  
    // Eliminar una pregunta
    public function destroy($id)
    {
        $question = Question::findOrFail($id);
        $question->answers()->delete();
        $question->delete();

        return redirect()->route('questions.index')
                     ->with('success', 'Pregunta eliminada exitosamente.');
    }
    public function getFilteredOptions(Request $request)
    {
    	$segmentId = $request->input('segment_id');
    	$regions = Region::where('segment_id', $segmentId)->get();
    	$departments = Department::where('segment_id', $segmentId)->get();
    	$municipalities = Municipality::where('segment_id', $segmentId)->get();
    	$districts = District::where('segment_id', $segmentId)->get();

    	return response()->json([
    	    'regions' => $regions,
    	    'departments' => $departments,
    	    'municipalities' => $municipalities,
    	    'districts' => $districts,
    	]);
    }
    public function checkType($id)
    {
        $question = Question::find($id);

        if (!$question) {
            return response()->json(['is_text_question' => false], 404);
        }

        return response()->json([
            'is_text_question' => $question->isTextQuestion(), // Asegúrate de que `isTextQuestion` devuelva un booleano
        ]);
    }
}
