<?php

namespace App\Http\Controllers;

use App\Models\Option;
use App\Models\Question;
use Illuminate\Http\Request;

class OptionController extends Controller
{
    // Mostrar el formulario para agregar opciones a una pregunta
    public function create()
    {
        $questions = Question::all();
        return view('survey.options.create', compact('questions'));
    }

    // Guardar las opciones en la base de datos
    public function store(Request $request)
    {
        $request->validate([
            'question_id' => 'required|exists:questions,id',
            'option_text' => 'required|string|max:255',
            'option_value' => 'required|string|max:255',
	    'requires_text_input' => 'boolean',
        ]);

        Option::create([
            'question_id' => $request->input('question_id'),
            'option_text' => $request->input('option_text'),
            'option_value' => $request->input('option_value'),
	    'requires_text_input' => $request->input('requires_text_input', false),
        ]);

        return redirect()->back()->with('success', 'Option added successfully.');
    }
    public function listOptions($questionId)
    {
     	$options = Option::where('question_id', $questionId)->get();
    	return response()->json($options);
    }

}
