<?php

namespace App\Http\Controllers;

use App\Models\Segment;
use App\Models\Region;
use App\Models\Department;
use App\Models\Muni;
use App\Models\Distrito;
use App\Models\Canton;
use App\Models\Household;
use App\Models\HouseholdMember;
use App\Models\HouseholdAssignment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log; // Asegúrate de usar Log para depuración
use Illuminate\Support\Facades\Auth;

class HouseholdVisitController extends Controller
{
    public function getSegmentDetail($correlativoSegmento)
    {
        // Obtener el segmento usando el correlativo_segmento
        $segment = Segment::where('correlativo_segmento', $correlativoSegmento)->first();

        if (!$segment) {
            return response()->json(['error' => 'Segmento no encontrado'], 404);
        }

        // Registrar el segmento para depuración (opcional)
        // Obtener los nombres de las regiones, departamentos, municipios y distritos usando joins
        $region = Region::where('codigo', $segment->region)->first();
        $department = Department::where('codigo', $segment->dpto)->first();
        $muni = Muni::where('codigo', $segment->muni)->first();
        $distrito = Distrito::where('codigo', $segment->distrito)->first();
        $canton = Canton::where('codigo', $segment->canton)->first(); // Asegúrate de que este código sea correcto
	 // Devolver los detalles como JSON
        return response()->json([
            'region' => $region ? $region->nombre : null,
            'department' => $department ? $department->nombre : null,
            'muni' => $muni ? $muni->nombre : null,
            'distrito' => $distrito ? $distrito->nombre : null,
            'area' => $canton ? $canton->area : null // Suponiendo que este campo existe
        ]);
    }

    public function getSegmentDetails($correlativoSegmento)
    {
    // Obtener el segmento usando el correlativo_segmento
    $segment = Segment::where('correlativo_segmento', $correlativoSegmento)->first();

    if (!$segment) {
        return response()->json(['error' => 'Segmento no encontrado'], 404);
    }

    // Obtener los nombres de las regiones, departamentos, municipios y distritos usando joins
    $region = Region::where('codigo', $segment->region)->first();
    $department = Department::where('codigo', $segment->dpto)->first();
    $muni = Muni::where('codigo', $segment->muni)->first();
    $distrito = Distrito::where('codigo', $segment->distrito)->first();
    $canton = Canton::where('codigo', '01')->first(); // Asegúrate de que este código sea correcto

    // Obtener el ID del usuario autenticado
    $currentUserId = Auth::id();

    Log::info('Buscando hogares para el correlativo_segmento:', ['correlativo_segmento' => $segment->correlativo_segmento]);

    // Obtener los hogares para el correlativo_segmento utilizando el modelo Household
    $households = Household::where('correlativo_segmento', $segment->correlativo_segmento)->get();

    if ($households->isEmpty()) {
        return response()->json(['error' => 'No se encontraron hogares para este segmento'], 404);
    }

    // Recorremos cada hogar y contamos sus miembros, además de verificar si están bloqueados
    $householdsWithDetails = $households->map(function ($household) use ($currentUserId) {
        // Contar miembros del hogar
        $memberCount = HouseholdMember::where('household_id', $household->id)->count();

        // Verificar asignación
        $assignment = HouseholdAssignment::where('household_id', $household->id)->first();
        $isBlocked = $assignment && $assignment->user_id !== $currentUserId; // Bloqueado si el user_id es diferente

        // Agregar detalles al hogar
        return [
            'id' => $household->id,
            'orden_vivienda' => $household->orden_vivienda,
            'numero_vivienda' => $household->numero_vivienda,
            'members' => $memberCount,
            'isBlocked' => $isBlocked, // Indicar si el hogar está bloqueado
	    'status' => $household->status,
            'assigned_user' => $assignment ? $assignment->user_id : null // Usuario asignado, si existe
        ];
    });

    // Devolver los detalles como JSON
    return response()->json([
        'region' => $region ? $region->nombre : null,
        'department' => $department ? $department->nombre : null,
        'muni' => $muni ? $muni->nombre : null,
        'distrito' => $distrito ? $distrito->nombre : null,
        'area' => $canton ? $canton->area : null, // Suponiendo que este campo existe
        'households' => $householdsWithDetails
    ]);
    }
  
}

