<?php

namespace App\Http\Controllers;

use App\Models\Condition;
use App\Models\OptionCondition;
use App\Models\ValidationCondition;
use App\Models\Question;
use Illuminate\Http\Request;

class ConditionController extends Controller
{
    public function create()
    {
        $questions = Question::all(); // Trae todas las preguntas
        return view('survey.conditions.create', compact('questions'));
    }
    // Método para obtener las condiciones de una pregunta específica
    public function getConditionsByQuestion($questionId)
    {
        $optionConditions = OptionCondition::where('question_id', $questionId)
        ->get();

        $validationConditions = ValidationCondition::where('question_id', $questionId)->get();

        return response()->json([
            'optionConditions' => $optionConditions,
            'validationConditions' => $validationConditions
        ]);
    }
    public function store(Request $request)
    {
    // Validar el tipo de condición general
    $request->validate([
        'question_id' => 'required|exists:questions,id',
        'criteria' => 'required|in:all,any',
        'conditions' => 'required|array',
        'conditions.*.type' => 'required|in:option,validation',
        'conditions.*.dependent_question_id' => 'nullable|exists:questions,id',
        'conditions.*.option_type' => 'nullable|in:equals,not_equals,was_answered,not_answered',
        'conditions.*.option_value' => 'nullable|string|max:255',
        'conditions.*.validation_type' => 'nullable|in:equals,not_equals,greater_than,less_than,greater_than_or_equals,less_than_or_equals',
        'conditions.*.validation_value' => 'nullable',
    ]);

    $questionId = $request->input('question_id');
    $criteria = $request->input('criteria');
    $conditions = $request->input('conditions');

    foreach ($conditions as $condition) {
        if ($condition['type'] === 'option') {
            OptionCondition::create([
                'question_id' => $questionId,
                'dependent_question_id' => $condition['dependent_question_id'],
                'option_type' => $condition['option_type'],
                'option_value' => $condition['option_value'],
                'condition_logic' => $criteria, // Usar el criterio general aquí
            ]);
        } elseif ($condition['type'] === 'validation') {
            ValidationCondition::create([
                'question_id' => $questionId,
                'validation_type' => $condition['validation_type'],
                'validation_value' => $condition['validation_value'],
            ]);
        }
    }

    return response()->json(['success' => true]);
    }
    public function destroy($id)
    {
    // Encuentra la condición y elimínala
    $condition = OptionCondition::find($id); // O ValidationCondition si es el caso
    if ($condition) {
        $condition->delete();
        return response()->json(['success' => true]);
    }

    return response()->json(['success' => false, 'message' => 'Condición no encontrada'], 404);
    }

}
