<?php	

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AuthController extends Controller
{
    public function login(Request $request)
    {
	$request->validate([
        'username' => 'required|string',
        'password' => 'required|string',
    	]);

        $credentials = $request->only('username', 'password');

        if (Auth::attempt($credentials)) {
            $user = Auth::user();
            $token = $user->createToken('authToken')->plainTextToken;
            return response()->json([
		'name' => $user->name,
		'token' => $token,
            	'id' => $user->id,
        ]);
	}
         // Si la autenticación falla, registrar el error
    Log::error('Error de inicio de sesión', [
        'username' => $request->input('username'),
        'ip' => $request->ip()
    ]);
	 // Enviar mensaje de error como respuesta
    return response()->json(['message' => 'Credenciales incorrectas'], 401);
    }
    public function check(Request $request)
    {
        return response()->json(['authenticated' => $request->user() ? true : false]);
    }
}
